/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.OperationDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.HashSet;
import java.util.Set;

public class UniqueOperationNames
extends AbstractRule {
    private Set<String> operationNames = new HashSet<String>();

    public UniqueOperationNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        super.checkOperationDefinition(operationDefinition);
        String name = operationDefinition.getName();
        if (name == null) {
            return;
        }
        if (this.operationNames.contains(name)) {
            this.addError(ValidationErrorType.DuplicateOperationName, operationDefinition.getSourceLocation(), UniqueOperationNames.duplicateOperationNameMessage(name));
        } else {
            this.operationNames.add(name);
        }
    }

    static String duplicateOperationNameMessage(String definitionName) {
        return String.format("There can be only one operation named '%s'", definitionName);
    }
}

