/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.AstComparator;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Value;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OverlappingFieldsCanBeMerged
extends AbstractRule {
    private final List<FieldPair> alreadyChecked = new ArrayList<FieldPair>();

    public OverlappingFieldsCanBeMerged(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void leaveSelectionSet(SelectionSet selectionSet) {
        LinkedHashMap<String, List<FieldAndType>> fieldMap = new LinkedHashMap<String, List<FieldAndType>>();
        LinkedHashSet<String> visitedFragmentSpreads = new LinkedHashSet<String>();
        this.collectFields(fieldMap, selectionSet, this.getValidationContext().getOutputType(), visitedFragmentSpreads);
        List<Conflict> conflicts = this.findConflicts(fieldMap);
        for (Conflict conflict : conflicts) {
            this.addError(ValidationErrorType.FieldsConflict, conflict.fields, conflict.reason);
        }
    }

    private List<Conflict> findConflicts(Map<String, List<FieldAndType>> fieldMap) {
        ArrayList<Conflict> result = new ArrayList<Conflict>();
        for (String name : fieldMap.keySet()) {
            List<FieldAndType> fieldAndTypes = fieldMap.get(name);
            for (int i = 0; i < fieldAndTypes.size(); ++i) {
                for (int j = i + 1; j < fieldAndTypes.size(); ++j) {
                    Conflict conflict = this.findConflict(name, fieldAndTypes.get(i), fieldAndTypes.get(j));
                    if (conflict == null) continue;
                    result.add(conflict);
                }
            }
        }
        return result;
    }

    private boolean isAlreadyChecked(Field field1, Field field2) {
        for (FieldPair fieldPair : this.alreadyChecked) {
            if (fieldPair.field1 == field1 && fieldPair.field2 == field2) {
                return true;
            }
            if (fieldPair.field1 != field2 || fieldPair.field2 != field1) continue;
            return true;
        }
        return false;
    }

    private Conflict findConflict(String responseName, FieldAndType fieldAndTypeA, FieldAndType fieldAndTypeB) {
        Field fieldA = fieldAndTypeA.field;
        Field fieldB = fieldAndTypeB.field;
        if (this.isAlreadyChecked(fieldA, fieldB)) {
            return null;
        }
        this.alreadyChecked.add(new FieldPair(fieldA, fieldB));
        String fieldNameA = fieldA.getName();
        String fieldNameB = fieldB.getName();
        GraphQLType typeA = fieldAndTypeA.graphQLType;
        GraphQLType typeB = fieldAndTypeB.graphQLType;
        Conflict conflict = this.checkListAndNonNullConflict(responseName, fieldAndTypeA, fieldAndTypeB);
        if (conflict != null) {
            return conflict;
        }
        if (this.checkScalarAndEnumConflict(typeA = GraphQLTypeUtil.unwrapAll(typeA), typeB = GraphQLTypeUtil.unwrapAll(typeB))) {
            return this.mkNotSameTypeError(responseName, fieldA, fieldB, typeA, typeB);
        }
        if (!this.sameType(fieldAndTypeA.parentType, fieldAndTypeB.parentType) && fieldAndTypeA.parentType instanceof GraphQLObjectType && fieldAndTypeB.parentType instanceof GraphQLObjectType) {
            return null;
        }
        if (!fieldNameA.equals(fieldNameB)) {
            String reason = String.format("%s: %s and %s are different fields", responseName, fieldNameA, fieldNameB);
            return new Conflict(responseName, reason, fieldA, fieldB);
        }
        if (!this.sameType(typeA, typeB)) {
            return this.mkNotSameTypeError(responseName, fieldA, fieldB, typeA, typeB);
        }
        if (!this.sameArguments(fieldA.getArguments(), fieldB.getArguments())) {
            String reason = String.format("%s: they have differing arguments", responseName);
            return new Conflict(responseName, reason, fieldA, fieldB);
        }
        SelectionSet selectionSet1 = fieldA.getSelectionSet();
        SelectionSet selectionSet2 = fieldB.getSelectionSet();
        if (selectionSet1 != null && selectionSet2 != null) {
            LinkedHashSet<String> visitedFragmentSpreads = new LinkedHashSet<String>();
            LinkedHashMap<String, List<FieldAndType>> subFieldMap = new LinkedHashMap<String, List<FieldAndType>>();
            this.collectFields(subFieldMap, selectionSet1, typeA, visitedFragmentSpreads);
            this.collectFields(subFieldMap, selectionSet2, typeB, visitedFragmentSpreads);
            List<Conflict> subConflicts = this.findConflicts(subFieldMap);
            if (subConflicts.size() > 0) {
                String reason = String.format("%s: %s", responseName, this.joinReasons(subConflicts));
                ArrayList<Field> fields = new ArrayList<Field>();
                fields.add(fieldA);
                fields.add(fieldB);
                fields.addAll(this.collectFields(subConflicts));
                return new Conflict(responseName, reason, fields);
            }
        }
        return null;
    }

    private Conflict checkListAndNonNullConflict(String responseName, FieldAndType fieldAndTypeA, FieldAndType fieldAndTypeB) {
        GraphQLType typeA = fieldAndTypeA.graphQLType;
        GraphQLType typeB = fieldAndTypeB.graphQLType;
        while (true) {
            if ((GraphQLTypeUtil.isNonNull(typeA) || GraphQLTypeUtil.isNonNull(typeB)) && (GraphQLTypeUtil.isNullable(typeA) || GraphQLTypeUtil.isNullable(typeB))) {
                String reason = String.format("%s: fields have different nullability shapes", responseName);
                return new Conflict(responseName, reason, fieldAndTypeA.field, fieldAndTypeB.field);
            }
            if (!(!GraphQLTypeUtil.isList(typeA) && !GraphQLTypeUtil.isList(typeB) || GraphQLTypeUtil.isList(typeA) && GraphQLTypeUtil.isList(typeB))) {
                String reason = String.format("%s: fields have different list shapes", responseName);
                return new Conflict(responseName, reason, fieldAndTypeA.field, fieldAndTypeB.field);
            }
            if (GraphQLTypeUtil.isNotWrapped(typeA) && GraphQLTypeUtil.isNotWrapped(typeB)) break;
            typeA = GraphQLTypeUtil.unwrapOne(typeA);
            typeB = GraphQLTypeUtil.unwrapOne(typeB);
        }
        return null;
    }

    private boolean checkScalarAndEnumConflict(GraphQLType typeA, GraphQLType typeB) {
        if ((GraphQLTypeUtil.isScalar(typeA) || GraphQLTypeUtil.isScalar(typeB)) && !this.sameType(typeA, typeB)) {
            return true;
        }
        return (GraphQLTypeUtil.isEnum(typeA) || GraphQLTypeUtil.isEnum(typeB)) && !this.sameType(typeA, typeB);
    }

    private Conflict mkNotSameTypeError(String responseName, Field fieldA, Field fieldB, GraphQLType typeA, GraphQLType typeB) {
        String name1 = typeA != null ? typeA.getName() : "null";
        String name2 = typeB != null ? typeB.getName() : "null";
        String reason = String.format("%s: they return differing types %s and %s", responseName, name1, name2);
        return new Conflict(responseName, reason, fieldA, fieldB);
    }

    private List<Field> collectFields(List<Conflict> conflicts) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Conflict conflict : conflicts) {
            result.addAll(conflict.fields);
        }
        return result;
    }

    private String joinReasons(List<Conflict> conflicts) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        for (Conflict conflict : conflicts) {
            result.append(conflict.reason);
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length());
        result.append(")");
        return result.toString();
    }

    private boolean sameType(GraphQLType type1, GraphQLType type2) {
        if (type1 == null || type2 == null) {
            return true;
        }
        return type1.equals(type2);
    }

    private boolean sameValue(Value value1, Value value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null) {
            return false;
        }
        if (value2 == null) {
            return false;
        }
        return new AstComparator().isEqual(value1, value2);
    }

    private boolean sameArguments(List<Argument> arguments1, List<Argument> arguments2) {
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (Argument argument : arguments1) {
            Argument matchedArgument = this.findArgumentByName(argument.getName(), arguments2);
            if (matchedArgument == null) {
                return false;
            }
            if (this.sameValue(argument.getValue(), matchedArgument.getValue())) continue;
            return false;
        }
        return true;
    }

    private Argument findArgumentByName(String name, List<Argument> arguments) {
        for (Argument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    private void collectFields(Map<String, List<FieldAndType>> fieldMap, SelectionSet selectionSet, GraphQLType parentType, Set<String> visitedFragmentSpreads) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectFieldsForField(fieldMap, parentType, (Field)selection);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectFieldsForInlineFragment(fieldMap, visitedFragmentSpreads, parentType, (InlineFragment)selection);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFieldsForFragmentSpread(fieldMap, visitedFragmentSpreads, (FragmentSpread)selection);
        }
    }

    private void collectFieldsForFragmentSpread(Map<String, List<FieldAndType>> fieldMap, Set<String> visitedFragmentSpreads, FragmentSpread fragmentSpread) {
        FragmentDefinition fragment = this.getValidationContext().getFragment(fragmentSpread.getName());
        if (fragment == null) {
            return;
        }
        if (visitedFragmentSpreads.contains(fragment.getName())) {
            return;
        }
        visitedFragmentSpreads.add(fragment.getName());
        GraphQLOutputType graphQLType = (GraphQLOutputType)TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), fragment.getTypeCondition());
        this.collectFields(fieldMap, fragment.getSelectionSet(), graphQLType, visitedFragmentSpreads);
    }

    private void collectFieldsForInlineFragment(Map<String, List<FieldAndType>> fieldMap, Set<String> visitedFragmentSpreads, GraphQLType parentType, InlineFragment inlineFragment) {
        GraphQLType graphQLType = inlineFragment.getTypeCondition() != null ? (GraphQLOutputType)TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), inlineFragment.getTypeCondition()) : parentType;
        this.collectFields(fieldMap, inlineFragment.getSelectionSet(), graphQLType, visitedFragmentSpreads);
    }

    private void collectFieldsForField(Map<String, List<FieldAndType>> fieldMap, GraphQLType parentType, Field field) {
        String responseName;
        String string = responseName = field.getAlias() != null ? field.getAlias() : field.getName();
        if (!fieldMap.containsKey(responseName)) {
            fieldMap.put(responseName, new ArrayList());
        }
        GraphQLOutputType fieldType = null;
        GraphQLUnmodifiedType unwrappedParent = GraphQLTypeUtil.unwrapAll(parentType);
        if (unwrappedParent instanceof GraphQLFieldsContainer) {
            GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)((Object)unwrappedParent);
            GraphQLFieldDefinition fieldDefinition = this.getVisibleFieldDefinition(fieldsContainer, field);
            fieldType = fieldDefinition != null ? fieldDefinition.getType() : null;
        }
        fieldMap.get(responseName).add(new FieldAndType(field, fieldType, parentType));
    }

    private GraphQLFieldDefinition getVisibleFieldDefinition(GraphQLFieldsContainer fieldsContainer, Field field) {
        return this.getValidationContext().getSchema().getFieldVisibility().getFieldDefinition(fieldsContainer, field.getName());
    }

    private static class FieldAndType {
        final Field field;
        final GraphQLType graphQLType;
        final GraphQLType parentType;

        public FieldAndType(Field field, GraphQLType graphQLType, GraphQLType parentType) {
            this.field = field;
            this.graphQLType = graphQLType;
            this.parentType = parentType;
        }
    }

    private static class Conflict {
        final String responseName;
        final String reason;
        final List<Field> fields = new ArrayList<Field>();

        public Conflict(String responseName, String reason, Field field1, Field field2) {
            this.responseName = responseName;
            this.reason = reason;
            this.fields.add(field1);
            this.fields.add(field2);
        }

        public Conflict(String responseName, String reason, List<Field> fields) {
            this.responseName = responseName;
            this.reason = reason;
            this.fields.addAll(fields);
        }
    }

    private static class FieldPair {
        final Field field1;
        final Field field2;

        public FieldPair(Field field1, Field field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }
}

