/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Internal;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Internal
public class FpKit {
    public static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn, BinaryOperator<T> mergeFunc) {
        return namedObjects.stream().collect(Collectors.toMap(nameFn, Function.identity(), mergeFunc));
    }

    public static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn) {
        return FpKit.getByName(namedObjects, nameFn, FpKit.mergeFirst());
    }

    public static <T> BinaryOperator<T> mergeFirst() {
        return (o1, o2) -> o1;
    }

    public static <T> Collection<T> toCollection(Object iterableResult) {
        if (iterableResult.getClass().isArray()) {
            List collect = IntStream.range(0, Array.getLength(iterableResult)).mapToObj(i -> Array.get(iterableResult, i)).collect(Collectors.toList());
            return collect;
        }
        if (iterableResult instanceof Collection) {
            return (Collection)iterableResult;
        }
        Iterable iterable = (Iterable)iterableResult;
        Iterator iterator = iterable.iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> List<T> concat(List<T> l, T t) {
        return FpKit.concat(l, Collections.singletonList(t));
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> l = new ArrayList<T>(l1);
        l.addAll(l2);
        l.trimToSize();
        return l;
    }

    public static <T> List<T> valuesToList(Map<?, T> map) {
        return new ArrayList<T>(map.values());
    }
}

