/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.util.List;
import java.util.Optional;

@Internal
public class FetchSchemaDirectiveWiring
implements SchemaDirectiveWiring {
    public static final String FETCH = "fetch";

    @Override
    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        GraphQLFieldDefinition field = environment.getElement();
        String fetchName = this.atFetchFromSupport(field.getName(), field.getDirectives());
        PropertyDataFetcher dataFetcher = new PropertyDataFetcher(fetchName);
        return field.transform(builder -> builder.dataFetcher(dataFetcher));
    }

    private String atFetchFromSupport(String fieldName, List<GraphQLDirective> directives) {
        Optional<GraphQLArgument> from = DirectivesUtil.directiveWithArg(directives, FETCH, "from");
        return from.map(arg -> String.valueOf(arg.getValue())).orElse(fieldName);
    }
}

