/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.AssertException;
import graphql.Internal;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.HashMap;
import java.util.Map;

@Internal
public class GraphQLTypeCollectingVisitor
extends GraphQLTypeVisitorStub {
    private final Map<String, GraphQLType> result = new HashMap<String, GraphQLType>();

    @Override
    public TraversalControl visitGraphQLEnumType(GraphQLEnumType node, TraverserContext<GraphQLType> context) {
        this.assertTypeUniqueness(node, this.result);
        this.save(node.getName(), node);
        return super.visitGraphQLEnumType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLScalarType(GraphQLScalarType node, TraverserContext<GraphQLType> context) {
        this.assertTypeUniqueness(node, this.result);
        this.save(node.getName(), node);
        return super.visitGraphQLScalarType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLType> context) {
        if (this.isTypeReference(node.getName())) {
            this.assertTypeUniqueness(node, this.result);
        } else {
            this.save(node.getName(), node);
        }
        return super.visitGraphQLObjectType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType node, TraverserContext<GraphQLType> context) {
        if (this.isTypeReference(node.getName())) {
            this.assertTypeUniqueness(node, this.result);
        } else {
            this.save(node.getName(), node);
        }
        return super.visitGraphQLInputObjectType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLType> context) {
        if (this.isTypeReference(node.getName())) {
            this.assertTypeUniqueness(node, this.result);
        } else {
            this.save(node.getName(), node);
        }
        return super.visitGraphQLInterfaceType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLType> context) {
        this.assertTypeUniqueness(node, this.result);
        this.save(node.getName(), node);
        return super.visitGraphQLUnionType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLType> context) {
        return super.visitGraphQLFieldDefinition(node, context);
    }

    private boolean isTypeReference(String name) {
        return this.result.containsKey(name) && !(this.result.get(name) instanceof GraphQLTypeReference);
    }

    private void save(String name, GraphQLType type) {
        this.result.put(name, type);
    }

    private void assertTypeUniqueness(GraphQLType type, Map<String, GraphQLType> result) {
        GraphQLType existingType = result.get(type.getName());
        if (existingType != null && !(existingType instanceof GraphQLTypeReference) && !(type instanceof GraphQLTypeReference) && existingType != type) {
            throw new AssertException(String.format("All types within a GraphQL schema must have unique names. No two provided types may have the same name.\nNo provided type may have a name which conflicts with any built in types (including Scalar and Introspection types).\nYou have redefined the type '%s' from being a '%s' to a '%s'", type.getName(), existingType.getClass().getSimpleName(), type.getClass().getSimpleName()));
        }
    }

    public Map<String, GraphQLType> getResult() {
        return this.result;
    }
}

