/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SelectedField;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
public class DataFetchingFieldSelectionSetImpl
implements DataFetchingFieldSelectionSet {
    private static final DataFetchingFieldSelectionSet NOOP = new DataFetchingFieldSelectionSet(){

        @Override
        public Map<String, List<Field>> get() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Map<String, Object>> getArguments() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, GraphQLFieldDefinition> getDefinitions() {
            return Collections.emptyMap();
        }

        @Override
        public boolean contains(String fieldGlobPattern) {
            return false;
        }

        @Override
        public SelectedField getField(String fieldName) {
            return null;
        }

        @Override
        public List<SelectedField> getFields() {
            return Collections.emptyList();
        }

        @Override
        public List<SelectedField> getFields(String fieldGlobPattern) {
            return Collections.emptyList();
        }
    };
    private final List<Field> parentFields;
    private final GraphQLSchema graphQLSchema;
    private final GraphQLFieldsContainer parentFieldType;
    private final Map<String, Object> variables;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private Map<String, List<Field>> selectionSetFields;
    private Map<String, GraphQLFieldDefinition> selectionSetFieldDefinitions;
    private Map<String, Map<String, Object>> selectionSetFieldArgs;
    private Set<String> flattenedFields;
    private static final String SEP = "/";

    public static DataFetchingFieldSelectionSet newCollector(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields) {
        GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll(fieldType);
        if (unwrappedType instanceof GraphQLFieldsContainer) {
            return new DataFetchingFieldSelectionSetImpl(executionContext, (GraphQLFieldsContainer)((Object)unwrappedType), fields);
        }
        return NOOP;
    }

    private static GraphQLObjectType asObjectTypeOrNull(GraphQLType unwrappedType) {
        return unwrappedType instanceof GraphQLObjectType ? (GraphQLObjectType)unwrappedType : null;
    }

    private DataFetchingFieldSelectionSetImpl(ExecutionContext executionContext, GraphQLFieldsContainer parentFieldType, List<Field> parentFields) {
        this(parentFields, parentFieldType, executionContext.getGraphQLSchema(), executionContext.getVariables(), executionContext.getFragmentsByName());
    }

    public DataFetchingFieldSelectionSetImpl(List<Field> parentFields, GraphQLFieldsContainer parentFieldType, GraphQLSchema graphQLSchema, Map<String, Object> variables, Map<String, FragmentDefinition> fragmentsByName) {
        this.parentFields = parentFields;
        this.graphQLSchema = graphQLSchema;
        this.parentFieldType = parentFieldType;
        this.variables = variables;
        this.fragmentsByName = fragmentsByName;
    }

    @Override
    public Map<String, List<Field>> get() {
        this.computeValuesLazily();
        return this.selectionSetFields;
    }

    @Override
    public Map<String, Map<String, Object>> getArguments() {
        this.computeValuesLazily();
        return this.selectionSetFieldArgs;
    }

    @Override
    public Map<String, GraphQLFieldDefinition> getDefinitions() {
        this.computeValuesLazily();
        return this.selectionSetFieldDefinitions;
    }

    @Override
    public boolean contains(String fieldGlobPattern) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return false;
        }
        this.computeValuesLazily();
        PathMatcher globMatcher = this.globMatcher(fieldGlobPattern);
        for (String flattenedField : this.flattenedFields) {
            Path path = Paths.get(flattenedField, new String[0]);
            if (!globMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SelectedField getField(String fqFieldName) {
        this.computeValuesLazily();
        List<Field> fields = this.selectionSetFields.get(fqFieldName);
        if (fields == null) {
            return null;
        }
        GraphQLFieldDefinition fieldDefinition = this.selectionSetFieldDefinitions.get(fqFieldName);
        Map<String, Object> arguments = this.selectionSetFieldArgs.get(fqFieldName);
        arguments = arguments == null ? Collections.emptyMap() : arguments;
        return new SelectedFieldImpl(fqFieldName, fields, fieldDefinition, arguments);
    }

    @Override
    public List<SelectedField> getFields(String fieldGlobPattern) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return Collections.emptyList();
        }
        this.computeValuesLazily();
        ArrayList<String> targetNames = new ArrayList<String>();
        PathMatcher globMatcher = this.globMatcher(fieldGlobPattern);
        for (String flattenedField : this.flattenedFields) {
            Path path = Paths.get(flattenedField, new String[0]);
            if (!globMatcher.matches(path)) continue;
            targetNames.add(flattenedField);
        }
        return targetNames.stream().map(this::getField).collect(Collectors.toList());
    }

    @Override
    public List<SelectedField> getFields() {
        this.computeValuesLazily();
        return this.flattenedFields.stream().map(this::getField).collect(Collectors.toList());
    }

    private PathMatcher globMatcher(String fieldGlobPattern) {
        return FileSystems.getDefault().getPathMatcher("glob:" + fieldGlobPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeValuesLazily() {
        DataFetchingFieldSelectionSetImpl dataFetchingFieldSelectionSetImpl = this;
        synchronized (dataFetchingFieldSelectionSetImpl) {
            if (this.selectionSetFields != null) {
                return;
            }
            this.selectionSetFields = new LinkedHashMap<String, List<Field>>();
            this.selectionSetFieldDefinitions = new LinkedHashMap<String, GraphQLFieldDefinition>();
            this.selectionSetFieldArgs = new LinkedHashMap<String, Map<String, Object>>();
            this.flattenedFields = new LinkedHashSet<String>();
            this.traverseFields(this.parentFields, this.parentFieldType, "");
        }
    }

    private void traverseFields(List<Field> fieldList, GraphQLFieldsContainer parentFieldType, String fieldPrefix) {
        FieldCollector fieldCollector = new FieldCollector();
        ValuesResolver valuesResolver = new ValuesResolver();
        FieldCollectorParameters parameters = FieldCollectorParameters.newParameters().schema(this.graphQLSchema).objectType(DataFetchingFieldSelectionSetImpl.asObjectTypeOrNull(parentFieldType)).fragments(this.fragmentsByName).variables(this.variables).build();
        Map<String, List<Field>> collectedFields = fieldCollector.collectFields(parameters, fieldList);
        for (Map.Entry<String, List<Field>> entry : collectedFields.entrySet()) {
            String fieldName = this.mkFieldName(fieldPrefix, entry.getKey());
            List<Field> collectedFieldList = entry.getValue();
            this.selectionSetFields.put(fieldName, collectedFieldList);
            Field field = collectedFieldList.get(0);
            GraphQLFieldDefinition fieldDef = Introspection.getFieldDef(this.graphQLSchema, parentFieldType, field.getName());
            GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll(fieldDef.getType());
            Map<String, Object> argumentValues = valuesResolver.getArgumentValues(fieldDef.getArguments(), field.getArguments(), this.variables);
            this.selectionSetFieldArgs.put(fieldName, argumentValues);
            this.selectionSetFieldDefinitions.put(fieldName, fieldDef);
            this.flattenedFields.add(fieldName);
            if (!(unwrappedType instanceof GraphQLFieldsContainer)) continue;
            this.traverseFields(collectedFieldList, (GraphQLFieldsContainer)((Object)unwrappedType), fieldName);
        }
    }

    private String mkFieldName(String fieldPrefix, String fieldName) {
        return (!fieldPrefix.isEmpty() ? fieldPrefix + SEP : "") + fieldName;
    }

    private class SelectedFieldImpl
    implements SelectedField {
        private final String qualifiedName;
        private final String name;
        private final GraphQLFieldDefinition fieldDefinition;
        private final DataFetchingFieldSelectionSet selectionSet;
        private final Map<String, Object> arguments;

        private SelectedFieldImpl(String qualifiedName, List<Field> parentFields, GraphQLFieldDefinition fieldDefinition, Map<String, Object> arguments) {
            this.qualifiedName = qualifiedName;
            this.name = parentFields.get(0).getName();
            this.fieldDefinition = fieldDefinition;
            this.arguments = arguments;
            GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll(fieldDefinition.getType());
            this.selectionSet = unwrappedType instanceof GraphQLFieldsContainer ? new DataFetchingFieldSelectionSetImpl(parentFields, (GraphQLFieldsContainer)((Object)unwrappedType), DataFetchingFieldSelectionSetImpl.this.graphQLSchema, DataFetchingFieldSelectionSetImpl.this.variables, DataFetchingFieldSelectionSetImpl.this.fragmentsByName) : NOOP;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public GraphQLFieldDefinition getFieldDefinition() {
            return this.fieldDefinition;
        }

        @Override
        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        @Override
        public DataFetchingFieldSelectionSet getSelectionSet() {
            return this.selectionSet;
        }
    }
}

