/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import java.io.Serializable;

@PublicApi
public class SourceLocation
implements Serializable {
    private final int line;
    private final int column;
    private final String sourceName;

    public SourceLocation(int line, int column) {
        this(line, column, null);
    }

    public SourceLocation(int line, int column, String sourceName) {
        this.line = line;
        this.column = column;
        this.sourceName = sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        if (this.line != that.line) {
            return false;
        }
        if (this.column != that.column) {
            return false;
        }
        return this.sourceName != null ? this.sourceName.equals(that.sourceName) : that.sourceName == null;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + this.column;
        result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SourceLocation{line=" + this.line + ", column=" + this.column + (this.sourceName != null ? ", sourceName=" + this.sourceName : "") + '}';
    }
}

