/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.language.SourceLocation;
import graphql.language.VariableDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class OperationDefinition
extends AbstractNode<OperationDefinition>
implements Definition<OperationDefinition>,
SelectionSetContainer<OperationDefinition> {
    private final String name;
    private Operation operation;
    private final List<VariableDefinition> variableDefinitions;
    private final List<Directive> directives;
    private SelectionSet selectionSet;

    @Internal
    protected OperationDefinition(String name, Operation operation, List<VariableDefinition> variableDefinitions, List<Directive> directives, SelectionSet selectionSet, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.operation = operation;
        this.variableDefinitions = variableDefinitions;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public OperationDefinition(String name, Operation operation) {
        this(name, operation, new ArrayList<VariableDefinition>(), new ArrayList<Directive>(), null, null, new ArrayList<Comment>());
    }

    public OperationDefinition(String name) {
        this(name, null, new ArrayList<VariableDefinition>(), new ArrayList<Directive>(), null, null, new ArrayList<Comment>());
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.variableDefinitions);
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name) && this.operation == that.operation;
    }

    @Override
    public OperationDefinition deepCopy() {
        return new OperationDefinition(this.name, this.operation, this.deepCopy(this.variableDefinitions), this.deepCopy(this.directives), this.deepCopy(this.selectionSet), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "OperationDefinition{name='" + this.name + '\'' + ", operation=" + (Object)((Object)this.operation) + ", variableDefinitions=" + this.variableDefinitions + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitOperationDefinition(this, context);
    }

    public static Builder newOperationDefinition() {
        return new Builder();
    }

    public OperationDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private Operation operation;
        private List<VariableDefinition> variableDefinitions = new ArrayList<VariableDefinition>();
        private List<Directive> directives = new ArrayList<Directive>();
        private SelectionSet selectionSet;

        private Builder() {
        }

        private Builder(OperationDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.operation = existing.getOperation();
            this.variableDefinitions = existing.getVariableDefinitions();
            this.directives = existing.getDirectives();
            this.selectionSet = existing.getSelectionSet();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder variableDefinitions(List<VariableDefinition> variableDefinitions) {
            this.variableDefinitions = variableDefinitions;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder selectionSet(SelectionSet selectionSet) {
            this.selectionSet = selectionSet;
            return this;
        }

        public OperationDefinition build() {
            OperationDefinition operationDefinition = new OperationDefinition(this.name, this.operation, this.variableDefinitions, this.directives, this.selectionSet, this.sourceLocation, this.comments);
            return operationDefinition;
        }
    }

    public static enum Operation {
        QUERY,
        MUTATION,
        SUBSCRIPTION;

    }
}

