/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeVisitor;
import graphql.language.ObjectField;
import graphql.language.SourceLocation;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class ObjectValue
extends AbstractNode<ObjectValue>
implements Value<ObjectValue> {
    private final List<ObjectField> objectFields = new ArrayList<ObjectField>();

    @Internal
    protected ObjectValue(List<ObjectField> objectFields, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.objectFields.addAll(objectFields);
    }

    public ObjectValue(List<ObjectField> objectFields) {
        this(objectFields, null, new ArrayList<Comment>());
    }

    public List<ObjectField> getObjectFields() {
        return new ArrayList<ObjectField>(this.objectFields);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.objectFields);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectValue that = (ObjectValue)o;
        return true;
    }

    @Override
    public ObjectValue deepCopy() {
        return new ObjectValue(this.deepCopy(this.objectFields), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "ObjectValue{objectFields=" + this.objectFields + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitObjectValue(this, context);
    }

    public static Builder newObjectValue() {
        return new Builder();
    }

    public ObjectValue transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<ObjectField> objectFields = new ArrayList<ObjectField>();
        private List<Comment> comments = new ArrayList<Comment>();

        private Builder() {
        }

        private Builder(ObjectValue existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.objectFields = existing.getObjectFields();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder objectFields(List<ObjectField> objectFields) {
            this.objectFields = objectFields;
            return this;
        }

        public Builder objectField(ObjectField objectField) {
            this.objectFields.add(objectField);
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public ObjectValue build() {
            ObjectValue objectValue = new ObjectValue(this.objectFields, this.sourceLocation, this.comments);
            return objectValue;
        }
    }
}

