/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.NamedNode;
import graphql.language.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@PublicApi
public class NodeParentTree<T extends Node> {
    private final T node;
    private final Optional<NodeParentTree<T>> parent;
    private final List<String> path;

    @Internal
    public NodeParentTree(Deque<T> nodeStack) {
        Assert.assertNotNull(nodeStack, "You MUST have a non null stack of nodes", new Object[0]);
        Assert.assertTrue(!nodeStack.isEmpty(), "You MUST have a non empty stack of nodes", new Object[0]);
        ArrayDeque<T> copy = new ArrayDeque<T>(nodeStack);
        this.path = this.mkPath(copy);
        this.node = (Node)copy.pop();
        this.parent = !copy.isEmpty() ? Optional.of(new NodeParentTree<T>(copy)) : Optional.empty();
    }

    private List<String> mkPath(Deque<T> copy) {
        return copy.stream().filter(node1 -> node1 instanceof NamedNode).map(node1 -> ((NamedNode)node1).getName()).collect(Collectors.toList());
    }

    public T getNode() {
        return this.node;
    }

    public Optional<NodeParentTree<T>> getParentInfo() {
        return this.parent;
    }

    public List<String> getPath() {
        return this.path;
    }

    public String toString() {
        return String.valueOf(this.node) + " - parent : " + this.parent.isPresent();
    }
}

