/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class InputValueDefinition
extends AbstractNode<InputValueDefinition>
implements DirectivesContainer<InputValueDefinition> {
    private final String name;
    private final Type type;
    private final Value defaultValue;
    private final Description description;
    private final List<Directive> directives;

    @Internal
    protected InputValueDefinition(String name, Type type, Value defaultValue, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.directives = directives;
        this.description = description;
    }

    public InputValueDefinition(String name, Type type) {
        this(name, type, null, new ArrayList<Directive>(), null, null, new ArrayList<Comment>());
    }

    public InputValueDefinition(String name, Type type, Value defaultValue) {
        this(name, type, defaultValue, new ArrayList<Directive>(), null, null, new ArrayList<Comment>());
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        if (this.defaultValue != null) {
            result.add(this.defaultValue);
        }
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputValueDefinition that = (InputValueDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public InputValueDefinition deepCopy() {
        return new InputValueDefinition(this.name, this.deepCopy(this.type), this.deepCopy(this.defaultValue), this.deepCopy(this.directives), this.description, this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "InputValueDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInputValueDefinition(this, context);
    }

    public static Builder newInputValueDefinition() {
        return new Builder();
    }

    public InputValueDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private Type type;
        private Value defaultValue;
        private Description description;
        private List<Directive> directives = new ArrayList<Directive>();

        private Builder() {
        }

        private Builder(InputValueDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.type = existing.getType();
            this.defaultValue = existing.getDefaultValue();
            this.description = existing.getDescription();
            this.directives = existing.getDirectives();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Value defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder directive(Directive directive) {
            this.directives.add(directive);
            return this;
        }

        public InputValueDefinition build() {
            InputValueDefinition inputValueDefinition = new InputValueDefinition(this.name, this.type, this.defaultValue, this.directives, this.description, this.sourceLocation, this.comments);
            return inputValueDefinition;
        }
    }
}

