/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Comment;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class Directive
extends AbstractNode<Directive>
implements NamedNode<Directive> {
    private final String name;
    private final List<Argument> arguments = new ArrayList<Argument>();

    @Internal
    protected Directive(String name, List<Argument> arguments, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.arguments.addAll(arguments);
    }

    public Directive(String name, List<Argument> arguments) {
        this(name, arguments, null, new ArrayList<Comment>());
    }

    public Directive(String name) {
        this(name, new ArrayList<Argument>(), null, new ArrayList<Comment>());
    }

    public List<Argument> getArguments() {
        return new ArrayList<Argument>(this.arguments);
    }

    public Map<String, Argument> getArgumentsByName() {
        return NodeUtil.argumentsByName(this.arguments);
    }

    public Argument getArgument(String argumentName) {
        return this.getArgumentsByName().get(argumentName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        return new ArrayList<Node>(this.arguments);
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Directive that = (Directive)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public Directive deepCopy() {
        return new Directive(this.name, this.deepCopy(this.arguments), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "Directive{name='" + this.name + '\'' + ", arguments=" + this.arguments + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitDirective(this, context);
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public Directive transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private List<Argument> arguments = new ArrayList<Argument>();

        private Builder() {
        }

        private Builder(Directive existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.arguments = existing.getArguments();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder arguments(List<Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Directive build() {
            Directive directive = new Directive(this.name, this.arguments, this.sourceLocation, this.comments);
            return directive;
        }
    }
}

