/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.Internal;
import graphql.execution.ExecutionPath;
import graphql.execution.FieldValueInfo;
import graphql.execution.instrumentation.DeferredFieldInstrumentationContext;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.parameters.InstrumentationDeferredFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;

@Internal
public class FieldLevelTrackingApproach {
    private final DataLoaderRegistry dataLoaderRegistry;
    private final Logger log;

    public FieldLevelTrackingApproach(Logger log, DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.log = log;
    }

    public InstrumentationState createState() {
        return new CallStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters) {
        final CallStack callStack = (CallStack)parameters.getInstrumentationState();
        ExecutionPath path = parameters.getExecutionStrategyParameters().getPath();
        int parentLevel = path.getLevel();
        final int curLevel = parentLevel + 1;
        int fieldCount = parameters.getExecutionStrategyParameters().getFields().size();
        CallStack callStack2 = callStack;
        synchronized (callStack2) {
            callStack.increaseExpectedFetchCount(curLevel, fieldCount);
            callStack.increaseHappenedStrategyCalls(curLevel);
        }
        return new ExecutionStrategyInstrumentationContext(){

            @Override
            public void onDispatched(CompletableFuture<ExecutionResult> result) {
            }

            @Override
            public void onCompleted(ExecutionResult result, Throwable t) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
                boolean dispatchNeeded;
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    dispatchNeeded = FieldLevelTrackingApproach.this.handleOnFieldValuesInfo(fieldValueInfoList, callStack, curLevel);
                }
                if (dispatchNeeded) {
                    FieldLevelTrackingApproach.this.dispatch();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeferredField(List<Field> field) {
                boolean dispatchNeeded;
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    callStack.increaseFetchCount(curLevel);
                    dispatchNeeded = FieldLevelTrackingApproach.this.dispatchIfNeeded(callStack, curLevel);
                }
                if (dispatchNeeded) {
                    FieldLevelTrackingApproach.this.dispatch();
                }
            }
        };
    }

    private boolean handleOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList, CallStack callStack, int curLevel) {
        callStack.increaseHappenedOnFieldValueCalls(curLevel);
        int expectedStrategyCalls = 0;
        for (FieldValueInfo fieldValueInfo : fieldValueInfoList) {
            if (fieldValueInfo.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++expectedStrategyCalls;
                continue;
            }
            if (fieldValueInfo.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            expectedStrategyCalls += this.getCountForList(fieldValueInfo);
        }
        callStack.increaseExpectedStrategyCalls(curLevel + 1, expectedStrategyCalls);
        return this.dispatchIfNeeded(callStack, curLevel + 1);
    }

    private int getCountForList(FieldValueInfo fieldValueInfo) {
        int result = 0;
        for (FieldValueInfo cvi : fieldValueInfo.getFieldValueInfos()) {
            if (cvi.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++result;
                continue;
            }
            if (cvi.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            result += this.getCountForList(cvi);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeferredFieldInstrumentationContext beginDeferredField(InstrumentationDeferredFieldParameters parameters) {
        final CallStack callStack = (CallStack)parameters.getInstrumentationState();
        final int level = parameters.getExecutionStrategyParameters().getPath().getLevel();
        CallStack callStack2 = callStack;
        synchronized (callStack2) {
            callStack.clearAndMarkCurrentLevelAsReady(level);
        }
        return new DeferredFieldInstrumentationContext(){

            @Override
            public void onDispatched(CompletableFuture<ExecutionResult> result) {
            }

            @Override
            public void onCompleted(ExecutionResult result, Throwable t) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFieldValueInfo(FieldValueInfo fieldValueInfo) {
                boolean dispatchNeeded;
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    dispatchNeeded = FieldLevelTrackingApproach.this.handleOnFieldValuesInfo(Collections.singletonList(fieldValueInfo), callStack, level);
                }
                if (dispatchNeeded) {
                    FieldLevelTrackingApproach.this.dispatch();
                }
            }
        };
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        final CallStack callStack = (CallStack)parameters.getInstrumentationState();
        ExecutionPath path = parameters.getEnvironment().getExecutionStepInfo().getPath();
        final int level = path.getLevel();
        return new InstrumentationContext<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDispatched(CompletableFuture result) {
                boolean dispatchNeeded;
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    callStack.increaseFetchCount(level);
                    dispatchNeeded = FieldLevelTrackingApproach.this.dispatchIfNeeded(callStack, level);
                }
                if (dispatchNeeded) {
                    FieldLevelTrackingApproach.this.dispatch();
                }
            }

            @Override
            public void onCompleted(Object result, Throwable t) {
            }
        };
    }

    private boolean dispatchIfNeeded(CallStack callStack, int level) {
        if (this.levelReady(callStack, level)) {
            return callStack.dispatchIfNotDispatchedBefore(level);
        }
        return false;
    }

    private boolean levelReady(CallStack callStack, int level) {
        if (level == 1) {
            return callStack.allFetchesHappened(1);
        }
        return this.levelReady(callStack, level - 1) && callStack.allOnFieldCallsHappened(level - 1) && callStack.allStrategyCallsHappened(level) && callStack.allFetchesHappened(level);
    }

    void dispatch() {
        this.log.debug("Dispatching data loaders ({})", (Object)this.dataLoaderRegistry.getKeys());
        this.dataLoaderRegistry.dispatchAll();
    }

    private static class CallStack
    implements InstrumentationState {
        private final Map<Integer, Integer> expectedFetchCountPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> fetchCountPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> expectedStrategyCallsPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> happenedStrategyCallsPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Map<Integer, Integer> happenedOnFieldValueCallsPerLevel = new LinkedHashMap<Integer, Integer>();
        private final Set<Integer> dispatchedLevels = new LinkedHashSet<Integer>();

        CallStack() {
            this.expectedStrategyCallsPerLevel.put(1, 1);
        }

        int increaseExpectedFetchCount(int level, int count) {
            this.expectedFetchCountPerLevel.put(level, this.expectedFetchCountPerLevel.getOrDefault(level, 0) + count);
            return this.expectedFetchCountPerLevel.get(level);
        }

        void increaseFetchCount(int level) {
            this.fetchCountPerLevel.put(level, this.fetchCountPerLevel.getOrDefault(level, 0) + 1);
        }

        void increaseExpectedStrategyCalls(int level, int count) {
            this.expectedStrategyCallsPerLevel.put(level, this.expectedStrategyCallsPerLevel.getOrDefault(level, 0) + count);
        }

        void increaseHappenedStrategyCalls(int level) {
            this.happenedStrategyCallsPerLevel.put(level, this.happenedStrategyCallsPerLevel.getOrDefault(level, 0) + 1);
        }

        void increaseHappenedOnFieldValueCalls(int level) {
            this.happenedOnFieldValueCallsPerLevel.put(level, this.happenedOnFieldValueCallsPerLevel.getOrDefault(level, 0) + 1);
        }

        boolean allStrategyCallsHappened(int level) {
            return Objects.equals(this.happenedStrategyCallsPerLevel.get(level), this.expectedStrategyCallsPerLevel.get(level));
        }

        boolean allOnFieldCallsHappened(int level) {
            return Objects.equals(this.happenedOnFieldValueCallsPerLevel.get(level), this.expectedStrategyCallsPerLevel.get(level));
        }

        boolean allFetchesHappened(int level) {
            return Objects.equals(this.fetchCountPerLevel.get(level), this.expectedFetchCountPerLevel.get(level));
        }

        public String toString() {
            return "CallStack{expectedFetchCountPerLevel=" + this.expectedFetchCountPerLevel + ", fetchCountPerLevel=" + this.fetchCountPerLevel + ", expectedStrategyCallsPerLevel=" + this.expectedStrategyCallsPerLevel + ", happenedStrategyCallsPerLevel=" + this.happenedStrategyCallsPerLevel + ", happenedOnFieldValueCallsPerLevel=" + this.happenedOnFieldValueCallsPerLevel + ", dispatchedLevels" + this.dispatchedLevels + '}';
        }

        public boolean dispatchIfNotDispatchedBefore(int level) {
            if (this.dispatchedLevels.contains(level)) {
                Assert.assertShouldNeverHappen("level " + level + " already dispatched", new Object[0]);
                return false;
            }
            this.dispatchedLevels.add(level);
            return true;
        }

        public void clearAndMarkCurrentLevelAsReady(int level) {
            this.expectedFetchCountPerLevel.clear();
            this.fetchCountPerLevel.clear();
            this.expectedStrategyCallsPerLevel.clear();
            this.happenedStrategyCallsPerLevel.clear();
            this.happenedOnFieldValueCallsPerLevel.clear();
            this.dispatchedLevels.clear();
            this.expectedFetchCountPerLevel.put(level, 1);
            this.expectedStrategyCallsPerLevel.put(level, 1);
            this.happenedStrategyCallsPerLevel.put(level, 1);
        }
    }
}

