/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.schema.GraphQLType;

public class NonNullableFieldWasNullException
extends RuntimeException {
    private final ExecutionStepInfo executionStepInfo;
    private final ExecutionPath path;

    public NonNullableFieldWasNullException(ExecutionStepInfo executionStepInfo, ExecutionPath path) {
        super(NonNullableFieldWasNullException.mkMessage(Assert.assertNotNull(executionStepInfo), Assert.assertNotNull(path)));
        this.executionStepInfo = executionStepInfo;
        this.path = path;
    }

    public NonNullableFieldWasNullException(NonNullableFieldWasNullException previousException) {
        super(NonNullableFieldWasNullException.mkMessage(Assert.assertNotNull(previousException.executionStepInfo.getParent()), Assert.assertNotNull(previousException.executionStepInfo.getParent().getPath())), previousException);
        this.executionStepInfo = previousException.executionStepInfo.getParent();
        this.path = previousException.executionStepInfo.getParent().getPath();
    }

    private static String mkMessage(ExecutionStepInfo executionStepInfo, ExecutionPath path) {
        GraphQLType unwrappedTyped = executionStepInfo.getUnwrappedNonNullType();
        if (executionStepInfo.hasParent()) {
            GraphQLType unwrappedParentType = executionStepInfo.getParent().getUnwrappedNonNullType();
            return String.format("Cannot return null for non-nullable type: '%s' within parent '%s' (%s)", unwrappedTyped.getName(), unwrappedParentType.getName(), path);
        }
        return String.format("Cannot return null for non-nullable type: '%s' (%s)", unwrappedTyped.getName(), path);
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return "NonNullableFieldWasNullException{ path=" + this.path + " executionStepInfo=" + this.executionStepInfo + '}';
    }
}

