/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.language.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@PublicApi
@Deprecated
public class ExecutorServiceExecutionStrategy
extends ExecutionStrategy {
    final ExecutorService executorService;

    public ExecutorServiceExecutionStrategy(ExecutorService executorService) {
        this(executorService, new SimpleDataFetcherExceptionHandler());
    }

    public ExecutorServiceExecutionStrategy(ExecutorService executorService, DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        super(dataFetcherExceptionHandler);
        this.executorService = executorService;
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        if (this.executorService == null) {
            return new AsyncExecutionStrategy().execute(executionContext, parameters);
        }
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        ExecutionStrategyInstrumentationContext executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        Map<String, List<Field>> fields = parameters.getFields();
        LinkedHashMap<String, Future<CompletableFuture>> futures = new LinkedHashMap<String, Future<CompletableFuture>>();
        for (String fieldName : fields.keySet()) {
            List<Field> currentField = fields.get(fieldName);
            ExecutionPath fieldPath = parameters.getPath().segment(ExecutorServiceExecutionStrategy.mkNameForPath(currentField));
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.field(currentField).path(fieldPath));
            Callable<CompletableFuture> resolveField = () -> this.resolveField(executionContext, newParameters);
            futures.put(fieldName, this.executorService.submit(resolveField));
        }
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResultImpl>();
        executionStrategyCtx.onDispatched(overallResult);
        try {
            LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
            for (String fieldName : futures.keySet()) {
                ExecutionResult executionResult;
                try {
                    executionResult = (ExecutionResult)((CompletableFuture)((Future)futures.get(fieldName)).get()).join();
                }
                catch (CompletionException e) {
                    if (e.getCause() instanceof NonNullableFieldWasNullException) {
                        this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)e.getCause());
                        results = null;
                        break;
                    }
                    throw e;
                }
                results.put(fieldName, executionResult != null ? (Object)executionResult.getData() : null);
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(results, executionContext.getErrors());
            overallResult.complete(executionResult);
            overallResult = overallResult.whenComplete(executionStrategyCtx::onCompleted);
            return overallResult;
        }
        catch (InterruptedException | ExecutionException e) {
            executionStrategyCtx.onCompleted(null, e);
            throw new GraphQLException(e);
        }
    }
}

