/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.ExecutionStrategyParameters;
import graphql.language.Field;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class AbsoluteGraphQLError
implements GraphQLError {
    private final List<SourceLocation> locations;
    private final List<Object> absolutePath;
    private final String message;
    private final ErrorType errorType;
    private final Map<String, Object> extensions;

    AbsoluteGraphQLError(ExecutionStrategyParameters executionStrategyParameters, GraphQLError relativeError) {
        Assert.assertNotNull(executionStrategyParameters);
        Assert.assertNotNull(relativeError);
        this.absolutePath = this.createAbsolutePath(executionStrategyParameters, relativeError);
        this.locations = this.createAbsoluteLocations(relativeError, executionStrategyParameters.getField());
        this.message = relativeError.getMessage();
        this.errorType = relativeError.getErrorType();
        if (relativeError.getExtensions() != null) {
            this.extensions = new HashMap<String, Object>();
            this.extensions.putAll(relativeError.getExtensions());
        } else {
            this.extensions = null;
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public List<Object> getPath() {
        return this.absolutePath;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    private List<Object> createAbsolutePath(ExecutionStrategyParameters executionStrategyParameters, GraphQLError relativeError) {
        return Optional.ofNullable(relativeError.getPath()).map(originalPath -> {
            ArrayList<Object> path = new ArrayList<Object>();
            path.addAll(executionStrategyParameters.getPath().toList());
            path.addAll(relativeError.getPath());
            return path;
        }).map(Collections::unmodifiableList).orElse(null);
    }

    private List<SourceLocation> createAbsoluteLocations(GraphQLError relativeError, List<Field> fields) {
        Optional<Object> baseLocation = !fields.isEmpty() ? Optional.ofNullable(fields.get(0).getSourceLocation()) : Optional.empty();
        if (relativeError.getLocations() != null && relativeError.getLocations().isEmpty()) {
            return baseLocation.map(Collections::singletonList).orElse(null);
        }
        return Optional.ofNullable(relativeError.getLocations()).map(locations -> locations.stream().map(l -> baseLocation.map(base -> new SourceLocation(base.getLine() + l.getLine(), base.getColumn() + l.getColumn())).orElse(null)).collect(Collectors.toList())).map(Collections::unmodifiableList).orElse(null);
    }
}

