/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.extensions.EntryLink;
import com.google.gdata.data.webmastertools.BoolValueConstruct;
import com.google.gdata.data.webmastertools.CrawlRate;
import com.google.gdata.data.webmastertools.CrawlRateConstruct;
import com.google.gdata.data.webmastertools.DateTimeValueConstruct;
import com.google.gdata.data.webmastertools.DomainPreference;
import com.google.gdata.data.webmastertools.DomainPreferenceConstruct;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.data.webmastertools.RegionCodeValueConstruct;
import com.google.gdata.data.webmastertools.VerificationMethod;
import java.util.BitSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitesEntry
extends BaseEntry<SitesEntry> {
    private static final String INDEXED = "indexed";
    private static final String CRAWLED = "crawled";
    private static final String VERIFIED = "verified";
    private static final String GEOLOCATION = "geolocation";
    private static final String CRAWL_RATE = "crawl-rate";
    private static final String PREFERRED_DOMAIN = "preferred-domain";
    private static final String ENHANCED_IMAGE_SEARCH = "enhanced-image-search";
    private static final Category CATEGORY = Namespaces.createCategory("http://schemas.google.com/webmasters/tools/2007#site-info");

    public SitesEntry() {
        this.getCategories().add(CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        ExtensionDescription desc = EntryLink.getDefaultDescription();
        desc.setRepeatable(true);
        extProfile.declare(SitesEntry.class, desc);
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(Indexed.class));
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(Crawled.class));
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(Verified.class));
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(Geolocation.class));
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(CrawlingRate.class));
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(PreferredDomain.class));
        extProfile.declare(SitesEntry.class, ExtensionDescription.getDefaultDescription(EnhancedImageSearch.class));
        desc = ExtensionDescription.getDefaultDescription(VerificationMethod.class);
        desc.setRepeatable(true);
        extProfile.declare(SitesEntry.class, desc);
    }

    public void setIndexed(boolean isIndexed) {
        Indexed indexed = this.getExtension(Indexed.class);
        if (indexed == null) {
            indexed = new Indexed();
            this.setExtension(indexed);
        }
        indexed.setBooleanValue(isIndexed);
    }

    public boolean getIndexed() {
        Indexed indexed = this.getExtension(Indexed.class);
        if (indexed == null) {
            return false;
        }
        return indexed.getBooleanValue();
    }

    public void setCrawled(DateTime crawlTime) {
        Crawled crawled = this.getExtension(Crawled.class);
        if (crawled == null) {
            crawled = new Crawled();
            this.setExtension(crawled);
        }
        crawled.setDateTime(crawlTime);
    }

    public DateTime getCrawled() {
        Crawled crawled = this.getExtension(Crawled.class);
        if (crawled == null) {
            return null;
        }
        return crawled.getDateTime();
    }

    public void setVerified(boolean isVerified) {
        Verified verified = this.getExtension(Verified.class);
        if (verified == null) {
            verified = new Verified();
            this.setExtension(verified);
        }
        verified.setBooleanValue(isVerified);
    }

    public boolean getVerified() {
        Verified verified = this.getExtension(Verified.class);
        if (verified == null) {
            return false;
        }
        return verified.getBooleanValue();
    }

    public void setGeolocation(String regionCode) {
        Geolocation geolocation = this.getExtension(Geolocation.class);
        if (geolocation == null) {
            geolocation = new Geolocation();
            this.setExtension(geolocation);
        }
        geolocation.setValue(regionCode);
    }

    public String getGeolocation() {
        Geolocation geolocation = this.getExtension(Geolocation.class);
        return geolocation == null ? null : geolocation.getValue();
    }

    public void setCrawlRate(CrawlRate rate) {
        CrawlingRate crawlingRate = this.getExtension(CrawlingRate.class);
        if (crawlingRate == null) {
            crawlingRate = new CrawlingRate();
            this.setExtension(crawlingRate);
        }
        crawlingRate.setCrawlRate(rate);
    }

    public CrawlRate getCrawlRate() {
        CrawlingRate crawlingRate = this.getExtension(CrawlingRate.class);
        return crawlingRate == null ? null : crawlingRate.getCrawlRate();
    }

    public void setPreferredDomain(DomainPreference preference) {
        PreferredDomain preferredDomain = this.getExtension(PreferredDomain.class);
        if (preferredDomain == null) {
            preferredDomain = new PreferredDomain();
            this.setExtension(preferredDomain);
        }
        preferredDomain.setPreference(preference);
    }

    public DomainPreference getPreferredDomain() {
        PreferredDomain preferredDomain = this.getExtension(PreferredDomain.class);
        return preferredDomain == null ? null : preferredDomain.getPreference();
    }

    public void setEnhancedImageSearch(boolean enabled) {
        EnhancedImageSearch enhanced = this.getExtension(EnhancedImageSearch.class);
        if (enhanced == null) {
            enhanced = new EnhancedImageSearch();
            this.setExtension(enhanced);
        }
        enhanced.setBooleanValue(enabled);
    }

    public boolean getEnhancedImageSearch() {
        EnhancedImageSearch enhanced = this.getExtension(EnhancedImageSearch.class);
        return enhanced != null && enhanced.getBooleanValue();
    }

    public void addVerificationMethod(VerificationMethod method) {
        this.addRepeatingExtension(method);
    }

    public List<VerificationMethod> getVerificationMethods() {
        return this.getRepeatingExtension(VerificationMethod.class);
    }

    public List<EntryLink> getEntryLinks() {
        return this.getRepeatingExtension(EntryLink.class);
    }

    @Override
    protected void validate() throws IllegalStateException {
        boolean inUseFound = false;
        int numMethods = VerificationMethod.MethodType.values().length;
        BitSet foundMethods = new BitSet(numMethods);
        for (VerificationMethod m : this.getVerificationMethods()) {
            int methodIndex = m.getMethodType().ordinal();
            if (foundMethods.get(methodIndex)) {
                throw new IllegalStateException("Duplicate verification method.");
            }
            foundMethods.set(methodIndex);
            if (!m.getInUse()) continue;
            if (inUseFound) {
                throw new IllegalStateException("Only one method can be marked as in-use.");
            }
            inUseFound = true;
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="enhanced-image-search")
    public static class EnhancedImageSearch
    extends BoolValueConstruct {
        public EnhancedImageSearch() {
            super(SitesEntry.ENHANCED_IMAGE_SEARCH);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="preferred-domain")
    public static class PreferredDomain
    extends DomainPreferenceConstruct {
        public PreferredDomain() {
            super(SitesEntry.PREFERRED_DOMAIN);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="crawl-rate")
    public static class CrawlingRate
    extends CrawlRateConstruct {
        public CrawlingRate() {
            super(SitesEntry.CRAWL_RATE);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="geolocation")
    public static class Geolocation
    extends RegionCodeValueConstruct {
        public Geolocation() {
            super(SitesEntry.GEOLOCATION);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="verified")
    public static class Verified
    extends BoolValueConstruct {
        public Verified() {
            super(SitesEntry.VERIFIED);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="crawled")
    public static class Crawled
    extends DateTimeValueConstruct {
        public Crawled() {
            super(SitesEntry.CRAWLED);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="indexed")
    public static class Indexed
    extends BoolValueConstruct {
        public Indexed() {
            super(SitesEntry.INDEXED);
        }
    }
}

