/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="docs", nsUri="http://schemas.google.com/docs/2007", localName="maxUploadSize")
public class MaxUploadSize
extends AbstractExtension {
    static final String XML_NAME = "maxUploadSize";
    private static final String KIND = "kind";
    private String kind = null;
    private Long value = null;

    public MaxUploadSize() {
    }

    public MaxUploadSize(String kind, Long value) {
        this.setKind(kind);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.throwExceptionIfImmutable();
        this.kind = kind;
    }

    public boolean hasKind() {
        return this.getKind() != null;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.kind == null) {
            MaxUploadSize.throwExceptionForMissingAttribute(KIND);
        }
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
        if (this.value < 0L) {
            throw new IllegalStateException("Text content must be non-negative: " + this.value);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(MaxUploadSize.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(KIND, this.kind);
        generator.setContent(this.value.toString());
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.kind = helper.consume(KIND, true);
        this.value = helper.consumeLong(null, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        MaxUploadSize other = (MaxUploadSize)obj;
        return MaxUploadSize.eq(this.kind, other.kind) && MaxUploadSize.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.kind != null) {
            result = 37 * result + this.kind.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{MaxUploadSize kind=" + this.kind + " value=" + this.value + "}";
    }
}

