/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.contacts;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gContact", nsUri="http://schemas.google.com/contact/2008", localName="externalId")
public class ExternalId
extends ExtensionPoint {
    static final String XML_NAME = "externalId";
    private static final String LABEL = "label";
    private static final String REL = "rel";
    private static final String VALUE = "value";
    private String label = null;
    private String rel = null;
    private String value = null;

    public ExternalId() {
    }

    public ExternalId(String label, String rel, String value) {
        this.setLabel(label);
        this.setRel(rel);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.throwExceptionIfImmutable();
        this.label = label;
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.throwExceptionIfImmutable();
        this.rel = rel;
    }

    public boolean hasRel() {
        return this.getRel() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.value == null) {
            ExternalId.throwExceptionForMissingAttribute(VALUE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(ExternalId.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(LABEL, this.label);
        generator.put(REL, this.rel);
        generator.put(VALUE, this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.label = helper.consume(LABEL, false);
        this.rel = helper.consume(REL, false);
        this.value = helper.consume(VALUE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ExternalId other = (ExternalId)obj;
        return ExternalId.eq(this.label, other.label) && ExternalId.eq(this.rel, other.rel) && ExternalId.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.label != null) {
            result = 37 * result + this.label.hashCode();
        }
        if (this.rel != null) {
            result = 37 * result + this.rel.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{ExternalId label=" + this.label + " rel=" + this.rel + " value=" + this.value + "}";
    }

    public static final class Rel {
        public static final String ACCOUNT = "account";
        public static final String CUSTOMER = "customer";
        public static final String NETWORK = "network";
        public static final String ORGANIZATION = "organization";
    }
}

