/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.analytics.Definition;
import com.google.gdata.data.analytics.Property;
import com.google.gdata.util.ParseException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="dxp", nsUri="http://schemas.google.com/analytics/2009", localName="segment")
public class Segment
extends ExtensionPoint {
    static final String XML_NAME = "segment";
    private static final String ID = "id";
    private static final String NAME = "name";
    private String id = null;
    private String name = null;

    public Segment() {
    }

    public Segment(String id, String name) {
        this.setId(id);
        this.setName(name);
        this.setImmutable(true);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(Segment.class)) {
            return;
        }
        extProfile.declare(Segment.class, Definition.class);
        extProfile.declare(Segment.class, Property.getDefaultDescription(false, true));
    }

    public Definition getDefinition() {
        return this.getExtension(Definition.class);
    }

    public void setDefinition(Definition definition) {
        if (definition == null) {
            this.removeExtension(Definition.class);
        } else {
            this.setExtension(definition);
        }
    }

    public boolean hasDefinition() {
        return this.hasExtension(Definition.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.throwExceptionIfImmutable();
        this.id = id;
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public List<Property> getProperties() {
        return this.getRepeatingExtension(Property.class);
    }

    public void addProperty(Property property) {
        this.getProperties().add(property);
    }

    public boolean hasProperties() {
        return this.hasRepeatingExtension(Property.class);
    }

    @Override
    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Segment.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(ID, this.id);
        generator.put(NAME, this.name);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.id = helper.consume(ID, false);
        this.name = helper.consume(NAME, false);
    }

    public String toString() {
        return "{Segment id=" + this.id + " name=" + this.name + "}";
    }

    public String getProperty(String name) {
        if (this.hasProperties()) {
            for (Property property : this.getProperties()) {
                if (!property.hasName() || !property.getName().equalsIgnoreCase(name)) continue;
                return property.getValue();
            }
        }
        return null;
    }
}

