/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.gtt;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.Service;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.gtt.DocumentFeed;
import com.google.gdata.data.gtt.GlossaryFeed;
import com.google.gdata.data.gtt.TranslationMemoryFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class GttService
extends MediaService {
    public static final String GTT_SERVICE = "gtrans";
    public static final String GTT_SERVICE_VERSION = "GGtt-Java/" + GttService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(GttService.class, Versions.V1);

    public GttService(String applicationName) {
        super(GTT_SERVICE, applicationName);
        this.declareExtensions();
    }

    public GttService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public GttService(String applicationName, String protocol, String domainName) {
        super(GTT_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return GTT_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(GttService.class);
    }

    private void declareExtensions() {
        new AclFeed().declareExtensions(this.extProfile);
        new DocumentFeed().declareExtensions(this.extProfile);
        new GlossaryFeed().declareExtensions(this.extProfile);
        new TranslationMemoryFeed().declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(GttService.class, "1.0", Service.Versions.V2_1);

        private Versions() {
        }
    }
}

