/* Copyright (c) 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;

/**
 * Class that glues {@link ChangelogEntry} which was generated by the genesis
 * tool to its hand-written superclass ({@link DocumentListEntry}).
 *
 * @param <E> unused (necessary to meet the API that {@link ChangelogEntry}
 *    expects
 * 
 */
public class BaseDocumentListEntry<E> extends DocumentListEntry {

  /**
   * Constructs a new uninitialized entry, to be populated by the
   * GData parsers.
   */
  public BaseDocumentListEntry() {
    super();
  }

  /**
   * Constructs a new entry by doing a shallow copy from another {@link
   * BaseEntry} instance.
   */
  public BaseDocumentListEntry(BaseEntry<?> sourceEntry) {
    super(sourceEntry);
  }
}
