/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.testing.MetadataSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Arrays;
import javax.annotation.Nullable;

@CheckReturnValue
public final class LogDataSubject
extends Subject<LogDataSubject, LogData> {
    private static final Subject.Factory<LogDataSubject, LogData> LOG_DATA_SUBJECT_FACTORY = LogDataSubject::new;

    public static Subject.Factory<LogDataSubject, LogData> logData() {
        return LOG_DATA_SUBJECT_FACTORY;
    }

    public static LogDataSubject assertThat(@Nullable LogData logData) {
        return (LogDataSubject)Truth.assertAbout(LogDataSubject.logData()).that((Object)logData);
    }

    private LogDataSubject(FailureMetadata failureMetadata, @Nullable LogData subject) {
        super(failureMetadata, (Object)subject);
    }

    public MetadataSubject metadata() {
        return (MetadataSubject)this.check().about(MetadataSubject.metadata()).that((Object)((LogData)this.actual()).getMetadata());
    }

    public void hasMessage(Object messageOrLiteral) {
        if (((LogData)this.actual()).getTemplateContext() == null) {
            if (!Objects.equal((Object)((LogData)this.actual()).getLiteralArgument(), (Object)messageOrLiteral)) {
                this.fail("has literal", messageOrLiteral);
            }
        } else if (!((LogData)this.actual()).getTemplateContext().getMessage().equals(messageOrLiteral)) {
            this.fail("has format message", messageOrLiteral);
        }
    }

    public void hasArguments(Object ... args) {
        Object actualArgs = ImmutableList.of();
        if (((LogData)this.actual()).getTemplateContext() != null) {
            actualArgs = Arrays.asList(((LogData)this.actual()).getArguments());
        }
        this.check().that((Iterable)actualArgs).containsExactly(args).inOrder();
    }

    public void wasForced() {
        if (!((LogData)this.actual()).wasForced()) {
            this.fail("was forced");
        }
    }
}

