/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.flogger.backend.FormatChar;
import com.google.common.flogger.backend.FormatOptions;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import javax.annotation.Nullable;

public final class FormatOptionsSubject
extends Subject<FormatOptionsSubject, FormatOptions> {
    private static final Subject.Factory<FormatOptionsSubject, FormatOptions> FORMAT_OPTIONS_FACTORY = FormatOptionsSubject::new;

    public static FormatOptionsSubject assertThat(@Nullable FormatOptions formatOptions) {
        return (FormatOptionsSubject)Truth.assertAbout(FORMAT_OPTIONS_FACTORY).that((Object)formatOptions);
    }

    private FormatOptionsSubject(FailureMetadata failureMetadata, @Nullable FormatOptions subject) {
        super(failureMetadata, (Object)subject);
    }

    public void isDefault() {
        if (!((FormatOptions)this.actual()).isDefault()) {
            this.fail("is default");
        }
    }

    public void hasPrecision(int precision) {
        if (((FormatOptions)this.actual()).getPrecision() != precision) {
            this.fail("has precision", precision);
        }
    }

    public void hasWidth(int width) {
        if (((FormatOptions)this.actual()).getWidth() != width) {
            this.fail("has width", width);
        }
    }

    public void hasNoFlags() {
        if (((FormatOptions)this.actual()).getFlags() != 0) {
            this.fail("has no flags");
        }
    }

    public void shouldUpperCase() {
        if (!((FormatOptions)this.actual()).shouldUpperCase()) {
            this.fail("should upper case");
        }
    }

    public void shouldntUpperCase() {
        if (((FormatOptions)this.actual()).shouldUpperCase()) {
            this.fail("shouldn't upper case");
        }
    }

    public void shouldLeftAlign() {
        if (!((FormatOptions)this.actual()).shouldLeftAlign()) {
            this.fail("should left align");
        }
    }

    public void shouldntLeftAlign() {
        if (((FormatOptions)this.actual()).shouldLeftAlign()) {
            this.fail("shouldn't left align");
        }
    }

    public void shouldShowAltForm() {
        if (!((FormatOptions)this.actual()).shouldShowAltForm()) {
            this.fail("should show alt form");
        }
    }

    public void shouldntShowAltForm() {
        if (((FormatOptions)this.actual()).shouldShowAltForm()) {
            this.fail("shouldn't show alt form");
        }
    }

    public void shouldShowGrouping() {
        if (!((FormatOptions)this.actual()).shouldShowGrouping()) {
            this.fail("should show grouping");
        }
    }

    public void shouldntShowGrouping() {
        if (((FormatOptions)this.actual()).shouldShowGrouping()) {
            this.fail("shouldn't show grouping");
        }
    }

    public void shouldShowLeadingZeros() {
        if (!((FormatOptions)this.actual()).shouldShowLeadingZeros()) {
            this.fail("should show leading zeros");
        }
    }

    public void shouldntShowLeadingZeros() {
        if (((FormatOptions)this.actual()).shouldShowLeadingZeros()) {
            this.fail("shouldn't show leading zeros");
        }
    }

    public void shouldPrefixSpaceForPositiveValues() {
        if (!((FormatOptions)this.actual()).shouldPrefixSpaceForPositiveValues()) {
            this.fail("should prefix space for positive values");
        }
    }

    public void shouldntPrefixSpaceForPositiveValues() {
        if (((FormatOptions)this.actual()).shouldPrefixSpaceForPositiveValues()) {
            this.fail("shouldn't prefix space for positive values");
        }
    }

    public void shouldPrefixPlusForPositiveValues() {
        if (!((FormatOptions)this.actual()).shouldPrefixPlusForPositiveValues()) {
            this.fail("should prefix plus for positive values");
        }
    }

    public void shouldntPrefixPlusForPositiveValues() {
        if (((FormatOptions)this.actual()).shouldPrefixPlusForPositiveValues()) {
            this.fail("shouldn't prefix plus for positive values");
        }
    }

    public void areValidFor(FormatChar formatChar) {
        if (!((FormatOptions)this.actual()).areValidFor(formatChar)) {
            this.fail("%s should be valid", formatChar);
        }
    }

    public void areNotValidFor(FormatChar formatChar) {
        if (((FormatOptions)this.actual()).areValidFor(formatChar)) {
            this.fail("%s should not be valid", formatChar);
        }
    }
}

