/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.base.Preconditions;
import com.google.common.flogger.LogContext;
import com.google.common.flogger.LogFormat;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.backend.TemplateContext;
import com.google.common.flogger.parser.DefaultBraceStyleMessageParser;
import com.google.common.flogger.parser.DefaultPrintfMessageParser;
import com.google.common.flogger.parser.MessageParser;
import com.google.common.flogger.parser.PrintfMessageParser;
import com.google.common.flogger.testing.FakeLogSite;
import com.google.common.flogger.testing.FakeMetadata;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class FakeLogData
implements LogData {
    public static final String FAKE_LOGGER_NAME = "com.google.LoggerName";
    public static final String FAKE_LOGGING_CLASS = "com.google.FakeClass";
    public static final String FAKE_LOGGING_METHOD = "fakeMethod";
    public static final String FAKE_SOURCE_PATH = "src/com/google/FakeClass.java";
    public static final LogSite FAKE_LOG_SITE = FakeLogSite.create("com.google.FakeClass", "fakeMethod", 123, "src/com/google/FakeClass.java");
    private Level level = Level.INFO;
    private TemplateContext context = null;
    private Object[] arguments = null;
    private Object literalArgument = null;
    private long timestampNanos = 0L;
    private FakeMetadata metadata = new FakeMetadata();

    public static FakeLogData of(Object literalArgument) {
        return new FakeLogData(literalArgument);
    }

    public static FakeLogData of(LogFormat logFormat, String message, Object ... arguments) {
        return new FakeLogData(logFormat, message, arguments);
    }

    private FakeLogData(Object literalArgument) {
        this.literalArgument = literalArgument;
    }

    private FakeLogData(LogFormat logFormat, String message, Object ... arguments) {
        PrintfMessageParser parser = logFormat == LogFormat.PRINTF_STYLE ? DefaultPrintfMessageParser.getInstance() : DefaultBraceStyleMessageParser.getInstance();
        this.context = new TemplateContext((MessageParser)parser, message);
        this.arguments = arguments;
    }

    public FakeLogData setTimestampNanos(long timestampNanos) {
        this.timestampNanos = timestampNanos;
        return this;
    }

    public FakeLogData setLevel(Level level) {
        this.level = level;
        return this;
    }

    public <T> FakeLogData addMetadata(MetadataKey<T> key, Object value) {
        this.metadata.add(key, key.cast(value));
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    @Deprecated
    public long getTimestampMicros() {
        return TimeUnit.NANOSECONDS.toMicros(this.timestampNanos);
    }

    public long getTimestampNanos() {
        return this.timestampNanos;
    }

    public String getLoggerName() {
        return FAKE_LOGGER_NAME;
    }

    public LogSite getLogSite() {
        return FAKE_LOG_SITE;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean wasForced() {
        return Boolean.TRUE.equals(this.metadata.findValue(LogContext.Key.WAS_FORCED));
    }

    public TemplateContext getTemplateContext() {
        return this.context;
    }

    public Object[] getArguments() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"cannot get arguments without a context");
        return this.arguments;
    }

    public Object getLiteralArgument() {
        Preconditions.checkState((this.context == null ? 1 : 0) != 0, (Object)"cannot get literal argument if context exists");
        return this.literalArgument;
    }
}

