/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonHttpParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import java.io.IOException;

public class AccessTokenRequest
extends GenericData {
    @Key(value="grant_type")
    public String grantType = "none";
    @Key(value="client_id")
    public String clientId;
    public String clientSecret;
    @Key
    public String scope;
    public String authorizationServerUrl;
    public boolean useBasicAuthorization = true;

    public final HttpResponse execute() throws IOException {
        HttpTransport transport = new HttpTransport();
        transport.addParser((HttpParser)new JsonHttpParser());
        HttpRequest request = transport.buildPostRequest();
        if (this.useBasicAuthorization) {
            request.headers.setBasicAuthentication(this.clientId, this.clientSecret);
        } else {
            this.put("client_secret", this.clientSecret);
        }
        request.setUrl(this.authorizationServerUrl);
        UrlEncodedContent content = new UrlEncodedContent();
        content.data = this;
        request.content = content;
        return request.execute();
    }

    public static class RefreshTokenGrant
    extends AccessTokenRequest {
        @Key(value="refresh_token")
        public String refreshToken;

        public RefreshTokenGrant() {
            this.grantType = "refresh_token";
        }
    }

    public static class AssertionGrant
    extends AccessTokenRequest {
        @Key(value="assertion_type")
        public String assertionType;
        @Key
        public String assertion;

        public AssertionGrant() {
            this.grantType = "assertion";
        }
    }

    public static class ResourceOwnerPasswordCredentialsGrant
    extends AccessTokenRequest {
        @Key
        public String username;
        public String password;

        public ResourceOwnerPasswordCredentialsGrant() {
            this.grantType = "password";
        }
    }

    public static class AuthorizationCodeGrant
    extends AccessTokenRequest {
        @Key
        public String code;
        @Key(value="redirect_uri")
        public String redirectUri;

        public AuthorizationCodeGrant() {
            this.grantType = "authorization_code";
        }
    }
}

