/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2012-2023 the original author or authors.
 */
package org.assertj.core.error.uri;

import java.net.URI;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldHaveScheme extends BasicErrorMessageFactory {

  public static ErrorMessageFactory shouldHaveScheme(URI actual, String expectedScheme) {
    return new ShouldHaveScheme(actual, expectedScheme);
  }

  private ShouldHaveScheme(URI actual, String expectedScheme) {
    super("%nExpecting scheme of%n  <%s>%nto be:%n  <%s>%nbut was:%n  <%s>", actual, expectedScheme, actual.getScheme());
  }
}
