/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.HelloHandler;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ajax.JSON;

public class ManyHandlers {
    public static Server createServer(int port) throws IOException {
        Server server = new Server(port);
        ParamHandler param = new ParamHandler();
        WelcomeWrapHandler wrapper = new WelcomeWrapHandler();
        HelloHandler hello = new HelloHandler();
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(10);
        gzipHandler.addIncludedMimeTypes(new String[]{"text/plain"});
        gzipHandler.addIncludedMimeTypes(new String[]{"text/html"});
        Path requestLogFile = Files.createTempFile("demo", "log", new FileAttribute[0]);
        CustomRequestLog ncsaLog = new CustomRequestLog(requestLogFile.toString());
        server.setRequestLog((RequestLog)ncsaLog);
        HandlerList handlers = new HandlerList();
        wrapper.setHandler((Handler)hello);
        ContextHandler helloContext = new ContextHandler("/hello");
        helloContext.setHandler((Handler)wrapper);
        ContextHandler paramContext = new ContextHandler("/params");
        paramContext.setHandler((Handler)param);
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[]{helloContext, paramContext});
        gzipHandler.setHandler((Handler)contexts);
        handlers.addHandler((Handler)gzipHandler);
        handlers.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)handlers);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ManyHandlers.createServer(port);
        server.start();
        server.join();
    }

    public static class ParamHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            Map params = request.getParameterMap();
            if (!params.isEmpty()) {
                response.setContentType("text/plain");
                response.getWriter().println(new JSON().toJSON((Object)params));
                baseRequest.setHandled(true);
            }
        }
    }

    public static class WelcomeWrapHandler
    extends HandlerWrapper {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setHeader("X-Welcome", "Greetings from WelcomeWrapHandler");
            super.handle(target, baseRequest, request, response);
        }
    }
}

