/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Path;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.JettyDemos;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class OneWebAppWithJsp {
    public static Server createServer(int port) throws FileNotFoundException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        Path warFile = JettyDemos.find("demo-jsp-webapp/target/demo-jsp-webapp-@VER@.war");
        webapp.setWarResource((Resource)new PathResource(warFile));
        webapp.setExtractWAR(true);
        webapp.addConfiguration(new Configuration[]{new AnnotationConfiguration()});
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*/jakarta.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        server.setHandler((Handler)webapp);
        String realmResourceName = "etc/realm.properties";
        ClassLoader classLoader = OneWebAppWithJsp.class.getClassLoader();
        URL realmProps = classLoader.getResource(realmResourceName);
        if (realmProps == null) {
            throw new FileNotFoundException("Unable to find " + realmResourceName);
        }
        HashLoginService loginService = new HashLoginService();
        loginService.setName("Test Realm");
        loginService.setConfig(realmProps.toExternalForm());
        server.addBean((Object)loginService);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = OneWebAppWithJsp.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

