/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;

public class AsyncRestServer {
    public static void main(String[] args) throws Exception {
        Path home = FileSystems.getDefault().getPath(System.getProperty("jetty.home", "."), new String[0]).toAbsolutePath();
        Path war = home.resolve("../async-rest-webapp/target/async-rest/");
        if (!Files.exists(war, new LinkOption[0])) {
            war = home.resolve("examples/async-rest/async-rest-webapp/target/async-rest/");
        }
        if (!Files.exists(war, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot find async-rest webapp");
        }
        Server server = new Server(Integer.getInteger("jetty.http.port", 8080).intValue());
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setWar(war.toAbsolutePath().toString());
        server.setHandler((Handler)webapp);
        server.start();
        server.join();
    }
}

