/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.compression.NBitStringEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class LiteralNameEntryInstruction
implements Instruction {
    private final boolean _huffmanName;
    private final boolean _huffmanValue;
    private final String _name;
    private final String _value;

    public LiteralNameEntryInstruction(HttpField httpField, boolean huffman) {
        this(httpField, huffman, huffman);
    }

    public LiteralNameEntryInstruction(HttpField httpField, boolean huffmanName, boolean huffmanValue) {
        this._huffmanName = huffmanName;
        this._huffmanValue = huffmanValue;
        this._name = httpField.getName();
        this._value = httpField.getValue();
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitStringEncoder.octetsNeeded((int)6, (String)this._name, (boolean)this._huffmanName) + NBitStringEncoder.octetsNeeded((int)8, (String)this._value, (boolean)this._huffmanValue);
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)64);
        NBitStringEncoder.encode((ByteBuffer)buffer, (int)6, (String)this._name, (boolean)this._huffmanName);
        NBitStringEncoder.encode((ByteBuffer)buffer, (int)8, (String)this._value, (boolean)this._huffmanValue);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x[name=%s,value=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getName(), this.getValue());
    }
}

