/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.quic.client.ClientProtocolSession;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.thread.Scheduler;

public class ClientQuicSession
extends QuicSession {
    private final Map<String, Object> context;
    private final AtomicReference<Runnable> task = new AtomicReference();

    protected ClientQuicSession(Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, QuicheConnection quicheConnection, QuicConnection connection, InetSocketAddress remoteAddress, Map<String, Object> context) {
        super(executor, scheduler, byteBufferPool, quicheConnection, connection, (SocketAddress)remoteAddress);
        this.context = context;
    }

    void offerTask(Runnable task) {
        this.task.set(task);
    }

    protected Runnable pollTask() {
        return this.task.getAndSet(null);
    }

    protected ProtocolSession createProtocolSession() {
        ClientConnectionFactory connectionFactory = (ClientConnectionFactory)this.context.get("org.eclipse.jetty.client.connector.clientConnectionFactory");
        ProtocolSession.Factory factory = null;
        if (connectionFactory instanceof ProtocolSession.Factory) {
            factory = (ProtocolSession.Factory)connectionFactory;
        }
        if (factory == null && connectionFactory instanceof Container) {
            factory = ((Container)connectionFactory).getContainedBeans(ProtocolSession.Factory.class).stream().findFirst().orElse(null);
        }
        if (factory != null) {
            return factory.newProtocolSession((QuicSession)this, this.context);
        }
        return new ClientProtocolSession(this);
    }

    public Connection newConnection(QuicStreamEndPoint endPoint) {
        try {
            ClientConnectionFactory connectionFactory = (ClientConnectionFactory)this.context.get("org.eclipse.jetty.client.connector.clientConnectionFactory");
            return connectionFactory.newConnection((EndPoint)endPoint, this.context);
        }
        catch (IOException x) {
            throw new RuntimeIOException((Throwable)x);
        }
    }
}

