/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Graceful;

public class QuicSessionContainer
extends AbstractLifeCycle
implements QuicSession.Listener,
Graceful,
Dumpable {
    private final Set<QuicSession> sessions = ConcurrentHashMap.newKeySet();
    private final AtomicReference<CompletableFuture<Void>> shutdown = new AtomicReference();

    @Override
    public void onOpened(QuicSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onClosed(QuicSession session) {
        this.sessions.remove((Object)session);
    }

    public CompletableFuture<Void> shutdown() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture<Void> existing = this.shutdown.compareAndExchange(null, result);
        if (existing == null) {
            CompletableFuture.allOf((CompletableFuture[])this.sessions.stream().map(QuicSession::shutdown).toArray(CompletableFuture[]::new)).whenComplete((v, x) -> {
                if (x == null) {
                    result.complete((Void)v);
                } else {
                    result.completeExceptionally((Throwable)x);
                }
            });
            return result;
        }
        return existing;
    }

    public boolean isShutdown() {
        return this.shutdown.get() != null;
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{new DumpableCollection("sessions", this.sessions)});
    }
}

