/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.RedirectUtil;
import org.eclipse.jetty.util.annotation.Name;

public class RedirectPatternRule
extends PatternRule {
    private String _location;
    private int _statusCode = 302;

    public RedirectPatternRule() {
        this(null, null);
    }

    public RedirectPatternRule(@Name(value="pattern") String pattern, @Name(value="location") String location) {
        super(pattern);
        this._handling = true;
        this._terminating = true;
        this._location = location;
    }

    public void setLocation(String value) {
        this._location = value;
    }

    public void setStatusCode(int statusCode) {
        if (300 > statusCode && statusCode < 399) {
            throw new IllegalArgumentException("Invalid redirect status code " + statusCode + " (must be a value between 300 and 399)");
        }
        this._statusCode = statusCode;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String location = response.encodeRedirectURL(this._location);
        response.setHeader("Location", RedirectUtil.toRedirectURL(request, location));
        response.setStatus(this._statusCode);
        response.getOutputStream().flush();
        response.getOutputStream().close();
        return target;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(super.toString());
        str.append('[').append(this._statusCode);
        str.append('>').append(this._location);
        str.append(']');
        return str.toString();
    }
}

