/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.parser;

import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;

public interface ParserListener {
    default public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
    }

    default public void onData(long streamId, DataFrame frame) {
    }

    default public void onSettings(SettingsFrame frame) {
    }

    default public void onGoAway(GoAwayFrame frame) {
    }

    default public void onStreamFailure(long streamId, long error, Throwable failure) {
    }

    default public void onSessionFailure(long error, String reason, Throwable failure) {
    }

    public static class Wrapper
    implements ParserListener {
        protected final ParserListener listener;

        public Wrapper(ParserListener listener) {
            this.listener = listener;
        }

        @Override
        public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
            this.listener.onHeaders(streamId, frame, wasBlocked);
        }

        @Override
        public void onData(long streamId, DataFrame frame) {
            this.listener.onData(streamId, frame);
        }

        @Override
        public void onSettings(SettingsFrame frame) {
            this.listener.onSettings(frame);
        }

        @Override
        public void onStreamFailure(long streamId, long error, Throwable failure) {
            this.listener.onStreamFailure(streamId, error, failure);
        }

        @Override
        public void onSessionFailure(long error, String reason, Throwable failure) {
            this.listener.onSessionFailure(error, reason, failure);
        }
    }
}

