/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.hazelcast.session;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class HazelcastSessionDataStore
extends AbstractSessionDataStore
implements SessionDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastSessionDataStore.class);
    private IMap<String, SessionData> sessionDataMap;
    private boolean _useQueries;

    public void setUseQueries(boolean useQueries) {
        this._useQueries = useQueries;
    }

    public boolean isUseQueries() {
        return this._useQueries;
    }

    public SessionData doLoad(String id) throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading session {} from hazelcast", (Object)id);
            }
            SessionData sd = (SessionData)this.sessionDataMap.get((Object)this.getCacheKey(id));
            return sd;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (this.sessionDataMap == null) {
            return false;
        }
        this.sessionDataMap.delete((Object)this.getCacheKey(id));
        return true;
    }

    public IMap<String, SessionData> getSessionDataMap() {
        return this.sessionDataMap;
    }

    public void setSessionDataMap(IMap<String, SessionData> sessionDataMap) {
        this.sessionDataMap = sessionDataMap;
    }

    public void initialize(SessionContext context) throws Exception {
        super.initialize(context);
        if (this.isUseQueries()) {
            this.sessionDataMap.addIndex(new IndexConfig(IndexType.SORTED, new String[]{"expiry"}));
        }
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        this.sessionDataMap.set((Object)this.getCacheKey(id), (Object)data);
    }

    public boolean isPassivating() {
        return true;
    }

    public void doCleanOrphans(long timeLimit) {
        if (!this.isUseQueries()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Hazelcast useQueries=false, cannot clean orphaned sessions");
            }
            return;
        }
        PredicateBuilder.EntryObject eo = Predicates.newPredicateBuilder().getEntryObject();
        PredicateBuilder predicate = eo.get("expiry").greaterThan((Comparable)Integer.valueOf(0)).and((Predicate)eo.get("expiry").lessEqual((Comparable)Long.valueOf(timeLimit)));
        this.sessionDataMap.removeAll((Predicate)predicate);
    }

    public Set<String> doGetExpired(long time) {
        if (!this.isUseQueries()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Hazelcast useQueries=false, cannot search for expired sessions");
            }
            return Collections.emptySet();
        }
        AtomicReference reference = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        this._context.run(() -> {
            try {
                HashSet<String> ids = new HashSet<String>();
                PredicateBuilder.EntryObject eo = Predicates.newPredicateBuilder().getEntryObject();
                PredicateBuilder predicate = eo.get("expiry").greaterThan((Comparable)Integer.valueOf(0)).and((Predicate)eo.get("expiry").lessEqual((Comparable)Long.valueOf(time))).and((Predicate)eo.get("contextPath").equal((Comparable)((Object)this._context.getCanonicalContextPath())));
                Collection results = this.sessionDataMap.values((Predicate)predicate);
                if (results != null) {
                    for (SessionData sd : results) {
                        ids.add(sd.getId());
                    }
                }
                reference.set(ids);
            }
            catch (Exception e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            LOG.warn("Error querying for expired sessions {}", (Throwable)exception.get());
            return Collections.emptySet();
        }
        if (reference.get() == null) {
            return Collections.emptySet();
        }
        return (Set)reference.get();
    }

    public Set<String> doCheckExpired(Set<String> candidates, long time) {
        Set<String> expiredSessionIds = candidates.stream().filter(candidate -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking expiry for candidate {}", candidate);
            }
            try {
                SessionData sd = this.load((String)candidate);
                if (sd == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} does not exist in Hazelcast", candidate);
                    }
                    return true;
                }
                if (this._context.getWorkerName().equals(sd.getLastNode()) && sd.getExpiry() > 0L && sd.getExpiry() <= time) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} managed by {} is expired", candidate, (Object)this._context.getWorkerName());
                    }
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("Error checking if candidate {} is expired so expire it", candidate, (Object)e);
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        return expiredSessionIds;
    }

    public boolean doExists(String id) throws Exception {
        SessionData sd = this.doLoad(id);
        if (sd == null) {
            return false;
        }
        if (sd.getExpiry() <= 0L) {
            return true;
        }
        return sd.getExpiry() > System.currentTimeMillis();
    }

    public String getCacheKey(String id) {
        return this._context.getCanonicalContextPath() + "_" + this._context.getVhost() + "_" + id;
    }
}

