/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

public class FileServer {
    public static Server createServer(int port, Resource baseResource) throws Exception {
        Server server = new Server(port);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setBaseResource(baseResource);
        server.setHandler((Handler)new HandlerList(new Handler[]{resourceHandler, new DefaultHandler()}));
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        PathResource pathResource = new PathResource(userDir);
        Server server = FileServer.createServer(port, (Resource)pathResource);
        server.start();
        server.join();
    }
}

