/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.util.HashMap;
import java.util.Map;

public enum StreamType {
    CLIENT_BIDIRECTIONAL(0),
    SERVER_BIDIRECTIONAL(1),
    CLIENT_UNIDIRECTIONAL(2),
    SERVER_UNIDIRECTIONAL(3);

    private final int type;

    public static StreamType from(long streamId) {
        int type = (int)streamId & 3;
        return Types.types.get(type);
    }

    public static boolean isReserved(long streamType) {
        return (streamType - 33L) % 31L == 0L;
    }

    private StreamType(int type) {
        this.type = type;
        Types.types.put(type, this);
    }

    public int type() {
        return this.type;
    }

    private static class Types {
        private static final Map<Integer, StreamType> types = new HashMap<Integer, StreamType>();

        private Types() {
        }
    }
}

