/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerParser;

public class EncoderInstructionParser {
    private static final int SECTION_ACKNOWLEDGEMENT_PREFIX = 7;
    private static final int STREAM_CANCELLATION_PREFIX = 6;
    private static final int INSERT_COUNT_INCREMENT_PREFIX = 6;
    private final Handler _handler;
    private final NBitIntegerParser _integerParser;
    private State _state = State.IDLE;

    public EncoderInstructionParser(Handler handler) {
        this._handler = handler;
        this._integerParser = new NBitIntegerParser();
    }

    public void parse(ByteBuffer buffer) throws QpackException {
        if (buffer == null || !buffer.hasRemaining()) {
            return;
        }
        switch (this._state) {
            case IDLE: {
                byte firstByte = buffer.get(buffer.position());
                if ((firstByte & 0x80) != 0) {
                    this._state = State.SECTION_ACKNOWLEDGEMENT;
                    this._integerParser.setPrefix(7);
                    this.parseSectionAcknowledgment(buffer);
                    break;
                }
                if ((firstByte & 0x40) != 0) {
                    this._state = State.STREAM_CANCELLATION;
                    this._integerParser.setPrefix(6);
                    this.parseStreamCancellation(buffer);
                    break;
                }
                this._state = State.INSERT_COUNT_INCREMENT;
                this._integerParser.setPrefix(6);
                this.parseInsertCountIncrement(buffer);
                break;
            }
            case SECTION_ACKNOWLEDGEMENT: {
                this.parseSectionAcknowledgment(buffer);
                break;
            }
            case STREAM_CANCELLATION: {
                this.parseStreamCancellation(buffer);
                break;
            }
            case INSERT_COUNT_INCREMENT: {
                this.parseInsertCountIncrement(buffer);
                break;
            }
            default: {
                throw new IllegalStateException(this._state.name());
            }
        }
    }

    private void parseSectionAcknowledgment(ByteBuffer buffer) throws QpackException {
        long streamId = this._integerParser.decodeInt(buffer);
        if (streamId >= 0L) {
            this.reset();
            this._handler.onSectionAcknowledgement(streamId);
        }
    }

    private void parseStreamCancellation(ByteBuffer buffer) throws QpackException {
        long streamId = this._integerParser.decodeLong(buffer);
        if (streamId >= 0L) {
            this.reset();
            this._handler.onStreamCancellation(streamId);
        }
    }

    private void parseInsertCountIncrement(ByteBuffer buffer) throws QpackException {
        int increment = this._integerParser.decodeInt(buffer);
        if (increment >= 0) {
            this.reset();
            this._handler.onInsertCountIncrement(increment);
        }
    }

    public void reset() {
        this._state = State.IDLE;
        this._integerParser.reset();
    }

    private static enum State {
        IDLE,
        SECTION_ACKNOWLEDGEMENT,
        STREAM_CANCELLATION,
        INSERT_COUNT_INCREMENT;

    }

    public static interface Handler {
        public void onSectionAcknowledgement(long var1) throws QpackException;

        public void onStreamCancellation(long var1);

        public void onInsertCountIncrement(int var1) throws QpackException;
    }
}

