/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class SectionAcknowledgmentInstruction
implements Instruction {
    private final long _streamId;

    public SectionAcknowledgmentInstruction(long streamId) {
        this._streamId = streamId;
    }

    public long getStreamId() {
        return this._streamId;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitIntegerEncoder.octectsNeeded(7, this._streamId) + 1;
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)-128);
        NBitIntegerEncoder.encode(buffer, 7, this._streamId);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

