/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.resource.Resource;

@ManagedObject(value="Configure deployed webapps via properties")
public class PropertiesConfigurationManager
implements ConfigurationManager,
Dumpable {
    private String _properties;
    private final Map<String, String> _map = new HashMap<String, String>();

    public PropertiesConfigurationManager(String properties) {
        if (properties != null) {
            try {
                this.setFile(properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public PropertiesConfigurationManager() {
        this(null);
    }

    public void setFile(String resource) throws IOException {
        this._properties = resource;
        this._map.clear();
        this.loadProperties(this._properties);
    }

    @ManagedAttribute(value="A file or URL of properties")
    public String getFile() {
        return this._properties;
    }

    @ManagedOperation(value="Set a property")
    public void put(@Name(value="name") String name, @Name(value="value") String value) {
        this._map.put(name, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return this._map;
    }

    private void loadProperties(String resource) throws FileNotFoundException, IOException {
        Resource file = Resource.newResource((String)resource);
        if (file != null && file.exists()) {
            Properties properties = new Properties();
            properties.load(file.getInputStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._map.put(entry.getKey().toString(), String.valueOf(entry.getValue()));
            }
        }
    }

    public String toString() {
        return String.format("%s@%x{%s}", this.getClass(), this.hashCode(), this._properties);
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this.toString(), (Object[])new Object[]{this._map});
    }
}

