/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.osgi.boot.AbstractWebAppProvider;
import org.eclipse.jetty.osgi.boot.BundleProvider;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.utils.Util;
import org.eclipse.jetty.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWebAppProvider
extends AbstractWebAppProvider
implements BundleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebAppProvider.class);
    private Map<Bundle, App> _bundleMap = new HashMap<Bundle, App>();
    private ServiceRegistration _serviceRegForBundles;
    private WebAppTracker _webappTracker;

    public BundleWebAppProvider(ServerInstanceWrapper wrapper) {
        super(wrapper);
    }

    protected void doStart() throws Exception {
        this._webappTracker = new WebAppTracker(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), this.getServerInstanceWrapper().getManagedServerName());
        this._webappTracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", this.getServerInstanceWrapper().getManagedServerName());
        this._serviceRegForBundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(BundleProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._webappTracker.close();
        if (this._serviceRegForBundles != null) {
            try {
                this._serviceRegForBundles.unregister();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister {}", (Object)this._serviceRegForBundles, (Object)e);
            }
        }
        super.doStop();
    }

    @Override
    public boolean bundleAdded(Bundle bundle) throws Exception {
        if (bundle == null) {
            return false;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getServerInstanceWrapper().getParentClassLoaderForWebapps());
        String contextPath = null;
        try {
            Dictionary headers = bundle.getHeaders();
            String resourcePath = Util.getManifestHeaderValue("Jetty-WarResourcePath", headers);
            if (resourcePath != null) {
                String base = resourcePath;
                contextPath = BundleWebAppProvider.getContextPath(bundle);
                String originId = BundleWebAppProvider.getOriginId(bundle, base);
                AbstractWebAppProvider.OSGiApp app = new AbstractWebAppProvider.OSGiApp(this.getDeploymentManager(), this, bundle, originId);
                app.setWebAppPath(base);
                app.setContextPath(contextPath);
                this._bundleMap.put(bundle, app);
                this.getDeploymentManager().addApp((App)app);
                boolean bl = true;
                return bl;
            }
            if (bundle.getEntry("/WEB-INF/web.xml") != null) {
                String base = ".";
                contextPath = BundleWebAppProvider.getContextPath(bundle);
                String originId = BundleWebAppProvider.getOriginId(bundle, base);
                AbstractWebAppProvider.OSGiApp app = new AbstractWebAppProvider.OSGiApp(this.getDeploymentManager(), this, bundle, originId);
                app.setContextPath(contextPath);
                app.setWebAppPath(base);
                this._bundleMap.put(bundle, app);
                this.getDeploymentManager().addApp((App)app);
                boolean bl = true;
                return bl;
            }
            if (headers.get("Web-ContextPath") != null) {
                String base = ".";
                contextPath = (String)headers.get("Web-ContextPath");
                String originId = BundleWebAppProvider.getOriginId(bundle, base);
                AbstractWebAppProvider.OSGiApp app = new AbstractWebAppProvider.OSGiApp(this.getDeploymentManager(), this, bundle, originId);
                app.setContextPath(contextPath);
                app.setWebAppPath(base);
                this._bundleMap.put(bundle, app);
                this.getDeploymentManager().addApp((App)app);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public boolean bundleRemoved(Bundle bundle) throws Exception {
        App app = this._bundleMap.remove(bundle);
        if (app != null) {
            this.getDeploymentManager().removeApp(app);
            return true;
        }
        return false;
    }

    private static String getContextPath(Bundle bundle) {
        String location;
        String[] toks;
        int lastDot;
        Dictionary headers = bundle.getHeaders();
        Object contextPath = (String)headers.get("Web-ContextPath");
        if (contextPath == null && (lastDot = ((String)(contextPath = (toks = StringUtil.replace((String)(location = bundle.getLocation()), (char)'\\', (char)'/').split("/"))[toks.length - 1])).lastIndexOf(46)) != -1) {
            contextPath = ((String)contextPath).substring(0, lastDot);
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        return contextPath;
    }

    public class WebAppTracker
    extends BundleTracker {
        protected String _managedServerName;

        public WebAppTracker(BundleContext bundleContext, String managedServerName) {
            super(bundleContext, 48, null);
            this._managedServerName = managedServerName;
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            try {
                String serverName = (String)bundle.getHeaders().get("managedServerName");
                if ((StringUtil.isBlank((String)serverName) && this._managedServerName.equals("defaultJettyServer") || !StringUtil.isBlank((String)serverName) && serverName.equals(this._managedServerName)) && BundleWebAppProvider.this.bundleAdded(bundle)) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to add bundle {}", (Object)bundle, (Object)e);
            }
            return null;
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            try {
                BundleWebAppProvider.this.bundleRemoved(bundle);
            }
            catch (Exception e) {
                LOG.warn("Unable to remove bundle {}", (Object)bundle, (Object)e);
            }
        }
    }
}

