/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign.incubator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import jdk.incubator.foreign.Addressable;
import jdk.incubator.foreign.CLinker;
import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemoryLayout;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.foreign.incubator.quiche_h;
import org.eclipse.jetty.quic.quiche.foreign.incubator.quiche_path_stats;
import org.eclipse.jetty.quic.quiche.foreign.incubator.quiche_recv_info;
import org.eclipse.jetty.quic.quiche.foreign.incubator.quiche_send_info;
import org.eclipse.jetty.quic.quiche.foreign.incubator.quiche_stats;
import org.eclipse.jetty.quic.quiche.foreign.incubator.sockaddr;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignIncubatorQuicheConnection
extends QuicheConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignIncubatorQuicheConnection.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final AutoLock lock = new AutoLock();
    private MemoryAddress quicheConn;
    private MemoryAddress quicheConfig;
    private ResourceScope scope;
    private MemorySegment sendInfo;
    private MemorySegment recvInfo;
    private MemorySegment stats;
    private MemorySegment pathStats;

    private ForeignIncubatorQuicheConnection(MemoryAddress quicheConn, MemoryAddress quicheConfig, ResourceScope scope) {
        this.quicheConn = quicheConn;
        this.quicheConfig = quicheConfig;
        this.scope = scope;
        this.sendInfo = quiche_send_info.allocate(scope);
        this.recvInfo = quiche_recv_info.allocate(scope);
        this.stats = quiche_stats.allocate(scope);
        this.pathStats = quiche_path_stats.allocate(scope);
    }

    public static byte[] fromPacket(ByteBuffer packet) {
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            int rc;
            MemorySegment packetReadSegment;
            MemorySegment type = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
            MemorySegment version = MemorySegment.allocateNative((MemoryLayout)CLinker.C_INT, (ResourceScope)scope);
            MemorySegment scid = MemorySegment.allocateNative((long)20L, (ResourceScope)scope);
            MemorySegment scid_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(scid_len, scid.byteSize());
            MemorySegment dcid = MemorySegment.allocateNative((long)20L, (ResourceScope)scope);
            MemorySegment dcid_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(dcid_len, dcid.byteSize());
            MemorySegment token = MemorySegment.allocateNative((long)48L, (ResourceScope)scope);
            MemorySegment token_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(token_len, token.byteSize());
            LOG.debug("getting header info (fromPacket)...");
            if (packet.isDirect()) {
                packetReadSegment = MemorySegment.ofByteBuffer((ByteBuffer)packet);
                rc = quiche_h.quiche_header_info(packetReadSegment.address(), packet.remaining(), 20L, version.address(), type.address(), scid.address(), scid_len.address(), dcid.address(), dcid_len.address(), token.address(), token_len.address());
            } else {
                packetReadSegment = MemorySegment.allocateNative((long)packet.remaining(), (ResourceScope)scope);
                int prevPosition = packet.position();
                packetReadSegment.asByteBuffer().put(packet);
                packet.position(prevPosition);
                rc = quiche_h.quiche_header_info(packetReadSegment.address(), packet.remaining(), 20L, version.address(), type.address(), scid.address(), scid_len.address(), dcid.address(), dcid_len.address(), token.address(), token_len.address());
            }
            if (rc < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("quiche cannot read header info from packet {}", (Object)BufferUtil.toDetailString((ByteBuffer)packet));
                }
                packetReadSegment = null;
                return packetReadSegment;
            }
            byte[] bytes = new byte[(int)ForeignIncubatorQuicheConnection.getLong(dcid_len)];
            dcid.asByteBuffer().get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static ForeignIncubatorQuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer) throws IOException {
        return ForeignIncubatorQuicheConnection.connect(quicheConfig, local, peer, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForeignIncubatorQuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        if (connectionIdLength > 20) {
            throw new IOException("Connection ID length is too large: " + connectionIdLength + " > 20");
        }
        ResourceScope scope = ResourceScope.newSharedScope();
        boolean keepScope = false;
        try {
            byte[] scidBytes = new byte[connectionIdLength];
            SECURE_RANDOM.nextBytes(scidBytes);
            MemorySegment scid = MemorySegment.allocateNative((long)scidBytes.length, (ResourceScope)scope);
            scid.asByteBuffer().put(scidBytes);
            MemoryAddress libQuicheConfig = ForeignIncubatorQuicheConnection.buildConfig(quicheConfig, scope);
            MemorySegment localSockaddr = sockaddr.convert(local, scope);
            MemorySegment peerSockaddr = sockaddr.convert(peer, scope);
            MemoryAddress quicheConn = quiche_h.quiche_connect((Addressable)CLinker.toCString((String)peer.getHostString(), (ResourceScope)scope), (Addressable)scid, scid.byteSize(), (Addressable)localSockaddr, localSockaddr.byteSize(), (Addressable)peerSockaddr, peerSockaddr.byteSize(), (Addressable)libQuicheConfig);
            ForeignIncubatorQuicheConnection connection = new ForeignIncubatorQuicheConnection(quicheConn, libQuicheConfig, scope);
            keepScope = true;
            ForeignIncubatorQuicheConnection foreignIncubatorQuicheConnection = connection;
            return foreignIncubatorQuicheConnection;
        }
        finally {
            if (!keepScope) {
                scope.close();
            }
        }
    }

    private static MemoryAddress buildConfig(QuicheConfig config, ResourceScope scope) throws IOException {
        Long activeConnectionIdLimit;
        Long maxStreamWindow;
        Long maxConnectionWindow;
        Boolean disableActiveMigration;
        Long initialMaxStreamsUni;
        Long initialMaxStreamsBidi;
        Long initialMaxStreamDataUni;
        Long initialMaxStreamDataBidiRemote;
        Long initialMaxStreamDataBidiLocal;
        Long initialMaxData;
        Long maxIdleTimeout;
        QuicheConfig.CongestionControl cc;
        int rc;
        int rc2;
        int rc3;
        String trustedCertsPemPath;
        MemoryAddress quicheConfig = quiche_h.quiche_config_new(config.getVersion());
        if (quicheConfig == null) {
            throw new IOException("Failed to create quiche config");
        }
        Boolean verifyPeer = config.getVerifyPeer();
        if (verifyPeer != null) {
            quiche_h.quiche_config_verify_peer(quicheConfig, verifyPeer != false ? (byte)1 : 0);
        }
        if ((trustedCertsPemPath = config.getTrustedCertsPemPath()) != null && (rc3 = quiche_h.quiche_config_load_verify_locations_from_file(quicheConfig, CLinker.toCString((String)trustedCertsPemPath, (ResourceScope)scope).address())) < 0) {
            throw new IOException("Error loading trusted certificates file " + trustedCertsPemPath + " : " + Quiche.quiche_error.errToString((long)rc3));
        }
        String certChainPemPath = config.getCertChainPemPath();
        if (certChainPemPath != null && (rc2 = quiche_h.quiche_config_load_cert_chain_from_pem_file(quicheConfig, CLinker.toCString((String)certChainPemPath, (ResourceScope)scope).address())) < 0) {
            throw new IOException("Error loading certificate chain file " + certChainPemPath + " : " + Quiche.quiche_error.errToString((long)rc2));
        }
        String privKeyPemPath = config.getPrivKeyPemPath();
        if (privKeyPemPath != null && (rc = quiche_h.quiche_config_load_priv_key_from_pem_file(quicheConfig, CLinker.toCString((String)privKeyPemPath, (ResourceScope)scope).address())) < 0) {
            throw new IOException("Error loading private key file " + privKeyPemPath + " : " + Quiche.quiche_error.errToString((long)rc));
        }
        String[] applicationProtos = config.getApplicationProtos();
        if (applicationProtos != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String proto : applicationProtos) {
                byte[] bytes = proto.getBytes(StandardCharsets.UTF_8);
                baos.write(bytes.length);
                baos.write(bytes);
            }
            byte[] bytes = baos.toByteArray();
            MemorySegment segment = MemorySegment.allocateNative((long)bytes.length, (ResourceScope)scope);
            segment.asByteBuffer().put(bytes);
            quiche_h.quiche_config_set_application_protos(quicheConfig, segment.address(), segment.byteSize());
        }
        if ((cc = config.getCongestionControl()) != null) {
            quiche_h.quiche_config_set_cc_algorithm(quicheConfig, cc.getValue());
        }
        if ((maxIdleTimeout = config.getMaxIdleTimeout()) != null) {
            quiche_h.quiche_config_set_max_idle_timeout(quicheConfig, maxIdleTimeout);
        }
        if ((initialMaxData = config.getInitialMaxData()) != null) {
            quiche_h.quiche_config_set_initial_max_data(quicheConfig, initialMaxData);
        }
        if ((initialMaxStreamDataBidiLocal = config.getInitialMaxStreamDataBidiLocal()) != null) {
            quiche_h.quiche_config_set_initial_max_stream_data_bidi_local(quicheConfig, initialMaxStreamDataBidiLocal);
        }
        if ((initialMaxStreamDataBidiRemote = config.getInitialMaxStreamDataBidiRemote()) != null) {
            quiche_h.quiche_config_set_initial_max_stream_data_bidi_remote(quicheConfig, initialMaxStreamDataBidiRemote);
        }
        if ((initialMaxStreamDataUni = config.getInitialMaxStreamDataUni()) != null) {
            quiche_h.quiche_config_set_initial_max_stream_data_uni(quicheConfig, initialMaxStreamDataUni);
        }
        if ((initialMaxStreamsBidi = config.getInitialMaxStreamsBidi()) != null) {
            quiche_h.quiche_config_set_initial_max_streams_bidi(quicheConfig, initialMaxStreamsBidi);
        }
        if ((initialMaxStreamsUni = config.getInitialMaxStreamsUni()) != null) {
            quiche_h.quiche_config_set_initial_max_streams_uni(quicheConfig, initialMaxStreamsUni);
        }
        if ((disableActiveMigration = config.getDisableActiveMigration()) != null) {
            quiche_h.quiche_config_set_disable_active_migration(quicheConfig, disableActiveMigration != false ? (byte)1 : 0);
        }
        if ((maxConnectionWindow = config.getMaxConnectionWindow()) != null) {
            quiche_h.quiche_config_set_max_connection_window(quicheConfig, maxConnectionWindow);
        }
        if ((maxStreamWindow = config.getMaxStreamWindow()) != null) {
            quiche_h.quiche_config_set_max_stream_window(quicheConfig, maxStreamWindow);
        }
        if ((activeConnectionIdLimit = config.getActiveConnectionIdLimit()) != null) {
            quiche_h.quiche_config_set_active_connection_id_limit(quicheConfig, activeConnectionIdLimit);
        }
        return quicheConfig;
    }

    public static boolean negotiate(QuicheConnection.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            MemorySegment packetReadSegment;
            if (packetRead.isDirect()) {
                packetReadSegment = MemorySegment.ofByteBuffer((ByteBuffer)packetRead);
            } else {
                packetReadSegment = MemorySegment.allocateNative((long)packetRead.remaining(), (ResourceScope)scope);
                int prevPosition = packetRead.position();
                packetReadSegment.asByteBuffer().put(packetRead);
                packetRead.position(prevPosition);
            }
            MemorySegment type = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
            MemorySegment version = MemorySegment.allocateNative((MemoryLayout)CLinker.C_INT, (ResourceScope)scope);
            MemorySegment scid = MemorySegment.allocateNative((long)20L, (ResourceScope)scope);
            MemorySegment scid_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(scid_len, scid.byteSize());
            MemorySegment dcid = MemorySegment.allocateNative((long)20L, (ResourceScope)scope);
            MemorySegment dcid_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(dcid_len, dcid.byteSize());
            MemorySegment token = MemorySegment.allocateNative((long)48L, (ResourceScope)scope);
            MemorySegment token_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(token_len, token.byteSize());
            LOG.debug("getting header info (negotiate)...");
            int rc = quiche_h.quiche_header_info(packetReadSegment.address(), packetRead.remaining(), 20L, version.address(), type.address(), scid.address(), scid_len.address(), dcid.address(), dcid_len.address(), token.address(), token_len.address());
            if (rc < 0) {
                throw new IOException("failed to parse header: " + Quiche.quiche_error.errToString((long)rc));
            }
            packetRead.position(packetRead.limit());
            LOG.debug("version: {}", (Object)ForeignIncubatorQuicheConnection.getInt(version));
            LOG.debug("type: {}", (Object)ForeignIncubatorQuicheConnection.getByte(type));
            LOG.debug("scid len: {}", (Object)ForeignIncubatorQuicheConnection.getLong(scid_len));
            LOG.debug("dcid len: {}", (Object)ForeignIncubatorQuicheConnection.getLong(dcid_len));
            LOG.debug("token len: {}", (Object)ForeignIncubatorQuicheConnection.getLong(token_len));
            if (quiche_h.quiche_version_is_supported(ForeignIncubatorQuicheConnection.getInt(version)) == 0) {
                LOG.debug("version negotiation");
                MemorySegment packetToSendSegment = packetToSend.isDirect() ? MemorySegment.ofByteBuffer((ByteBuffer)packetToSend) : MemorySegment.allocateNative((long)packetToSend.remaining(), (ResourceScope)scope);
                long generated = quiche_h.quiche_negotiate_version(scid.address(), ForeignIncubatorQuicheConnection.getLong(scid_len), dcid.address(), ForeignIncubatorQuicheConnection.getLong(dcid_len), packetToSendSegment.address(), packetToSend.remaining());
                if (generated < 0L) {
                    throw new IOException("failed to create vneg packet : " + Quiche.quiche_error.errToString((long)generated));
                }
                if (!packetToSend.isDirect()) {
                    packetToSend.put(packetToSendSegment.asByteBuffer().limit((int)generated));
                } else {
                    packetToSend.position((int)((long)packetToSend.position() + generated));
                }
                boolean bl = true;
                return bl;
            }
            if (ForeignIncubatorQuicheConnection.getLong(token_len) == 0L) {
                LOG.debug("stateless retry");
                byte[] dcidBytes = new byte[(int)ForeignIncubatorQuicheConnection.getLong(dcid_len)];
                dcid.asByteBuffer().get(dcidBytes);
                byte[] tokenBytes = tokenMinter.mint(dcidBytes, dcidBytes.length);
                token.asByteBuffer().put(tokenBytes);
                byte[] newCid = new byte[20];
                SECURE_RANDOM.nextBytes(newCid);
                MemorySegment newCidSegment = MemorySegment.allocateNative((long)newCid.length, (ResourceScope)scope);
                newCidSegment.asByteBuffer().put(newCid);
                MemorySegment packetToSendSegment = packetToSend.isDirect() ? MemorySegment.ofByteBuffer((ByteBuffer)packetToSend) : MemorySegment.allocateNative((long)packetToSend.remaining(), (ResourceScope)scope);
                long generated = quiche_h.quiche_retry(scid.address(), ForeignIncubatorQuicheConnection.getLong(scid_len), dcid.address(), ForeignIncubatorQuicheConnection.getLong(dcid_len), newCidSegment.address(), newCid.length, token.address(), tokenBytes.length, ForeignIncubatorQuicheConnection.getInt(version), packetToSendSegment.address(), packetToSendSegment.byteSize());
                if (generated < 0L) {
                    throw new IOException("failed to create retry packet: " + Quiche.quiche_error.errToString((long)generated));
                }
                if (!packetToSend.isDirect()) {
                    packetToSend.put(packetToSendSegment.asByteBuffer().limit((int)generated));
                } else {
                    packetToSend.position((int)((long)packetToSend.position() + generated));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForeignIncubatorQuicheConnection tryAccept(QuicheConfig quicheConfig, QuicheConnection.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        boolean keepScope = false;
        ResourceScope scope = ResourceScope.newSharedScope();
        try {
            MemorySegment packetReadSegment;
            ResourceScope segmentScope;
            int rc;
            MemorySegment type = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
            MemorySegment version = MemorySegment.allocateNative((MemoryLayout)CLinker.C_INT, (ResourceScope)scope);
            MemorySegment scid = MemorySegment.allocateNative((long)20L, (ResourceScope)scope);
            MemorySegment scid_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(scid_len, scid.byteSize());
            MemorySegment dcid = MemorySegment.allocateNative((long)20L, (ResourceScope)scope);
            MemorySegment dcid_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(dcid_len, dcid.byteSize());
            MemorySegment token = MemorySegment.allocateNative((long)48L, (ResourceScope)scope);
            MemorySegment token_len = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
            ForeignIncubatorQuicheConnection.putLong(token_len, token.byteSize());
            LOG.debug("getting header info (tryAccept)...");
            if (packetRead.isDirect()) {
                MemorySegment packetReadSegment2 = MemorySegment.ofByteBuffer((ByteBuffer)packetRead);
                rc = quiche_h.quiche_header_info(packetReadSegment2.address(), packetRead.remaining(), 20L, version.address(), type.address(), scid.address(), scid_len.address(), dcid.address(), dcid_len.address(), token.address(), token_len.address());
            } else {
                segmentScope = ResourceScope.newConfinedScope();
                try {
                    packetReadSegment = MemorySegment.allocateNative((long)packetRead.remaining(), (ResourceScope)segmentScope);
                    int prevPosition = packetRead.position();
                    packetReadSegment.asByteBuffer().put(packetRead);
                    packetRead.position(prevPosition);
                    rc = quiche_h.quiche_header_info(packetReadSegment.address(), packetRead.remaining(), 20L, version.address(), type.address(), scid.address(), scid_len.address(), dcid.address(), dcid_len.address(), token.address(), token_len.address());
                }
                finally {
                    if (segmentScope != null) {
                        segmentScope.close();
                    }
                }
            }
            if (rc < 0) {
                throw new IOException("failed to parse header: " + Quiche.quiche_error.errToString((long)rc));
            }
            LOG.debug("version: {}", (Object)ForeignIncubatorQuicheConnection.getInt(version));
            LOG.debug("type: {}", (Object)ForeignIncubatorQuicheConnection.getByte(type));
            LOG.debug("scid len: {}", (Object)ForeignIncubatorQuicheConnection.getLong(scid_len));
            LOG.debug("dcid len: {}", (Object)ForeignIncubatorQuicheConnection.getLong(dcid_len));
            LOG.debug("token len: {}", (Object)ForeignIncubatorQuicheConnection.getLong(token_len));
            if (quiche_h.quiche_version_is_supported(ForeignIncubatorQuicheConnection.getInt(version)) == 0) {
                LOG.debug("need version negotiation");
                segmentScope = null;
                return segmentScope;
            }
            int tokenLen = (int)ForeignIncubatorQuicheConnection.getLong(token_len);
            if (tokenLen == 0) {
                LOG.debug("need stateless retry");
                packetReadSegment = null;
                return packetReadSegment;
            }
            LOG.debug("token validation...");
            byte[] tokenBytes = new byte[(int)token.byteSize()];
            token.asByteBuffer().get(tokenBytes, 0, tokenLen);
            byte[] odcidBytes = tokenValidator.validate(tokenBytes, tokenLen);
            if (odcidBytes == null) {
                throw new QuicheConnection.TokenValidationException("invalid address validation token");
            }
            LOG.debug("validated token");
            MemorySegment odcid = MemorySegment.allocateNative((long)odcidBytes.length, (ResourceScope)scope);
            odcid.asByteBuffer().put(odcidBytes);
            LOG.debug("connection creation...");
            MemoryAddress libQuicheConfig = ForeignIncubatorQuicheConnection.buildConfig(quicheConfig, scope);
            MemorySegment localSockaddr = sockaddr.convert(local, scope);
            MemorySegment peerSockaddr = sockaddr.convert(peer, scope);
            MemoryAddress quicheConn = quiche_h.quiche_accept(dcid.address(), ForeignIncubatorQuicheConnection.getLong(dcid_len), odcid.address(), odcid.byteSize(), localSockaddr.address(), localSockaddr.byteSize(), peerSockaddr.address(), peerSockaddr.byteSize(), libQuicheConfig);
            if (quicheConn == null) {
                quiche_h.quiche_config_free(libQuicheConfig);
                throw new IOException("failed to create connection");
            }
            LOG.debug("connection created");
            ForeignIncubatorQuicheConnection quicheConnection = new ForeignIncubatorQuicheConnection(quicheConn, libQuicheConfig, scope);
            LOG.debug("accepted, immediately receiving the same packet - remaining in buffer: {}", (Object)packetRead.remaining());
            while (packetRead.hasRemaining()) {
                quicheConnection.feedCipherBytes(packetRead, local, peer);
            }
            keepScope = true;
            ForeignIncubatorQuicheConnection foreignIncubatorQuicheConnection = quicheConnection;
            return foreignIncubatorQuicheConnection;
        }
        finally {
            if (!keepScope) {
                scope.close();
            }
        }
    }

    public byte[] getPeerCertificate() {
        try (AutoLock ignore = this.lock.lock();){
            byte[] byArray;
            block17: {
                long outLen;
                MemorySegment outSegment;
                ResourceScope scope;
                block15: {
                    byte[] byArray2;
                    block16: {
                        if (this.quicheConn == null) {
                            throw new IllegalStateException("connection was released");
                        }
                        scope = ResourceScope.newConfinedScope();
                        try {
                            outSegment = MemorySegment.allocateNative((MemoryLayout)CLinker.C_POINTER, (ResourceScope)scope);
                            MemorySegment outLenSegment = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                            quiche_h.quiche_conn_peer_cert(this.quicheConn, outSegment.address(), outLenSegment.address());
                            outLen = ForeignIncubatorQuicheConnection.getLong(outLenSegment);
                            if (outLen != 0L) break block15;
                            byArray2 = null;
                            if (scope == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return byArray2;
                }
                byte[] out = new byte[(int)outLen];
                MemoryAddress memoryAddress = MemoryAddress.ofLong((long)ForeignIncubatorQuicheConnection.getLong(outSegment));
                memoryAddress.asSegment(outLen, ResourceScope.globalScope()).asByteBuffer().get(out);
                byArray = out;
                if (scope == null) break block17;
                scope.close();
            }
            return byArray;
        }
    }

    protected List<Long> iterableStreamIds(boolean write) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            MemoryAddress quiche_stream_iter = write ? quiche_h.quiche_conn_writable(this.quicheConn) : quiche_h.quiche_conn_readable(this.quicheConn);
            ArrayList<Long> result = new ArrayList<Long>();
            try (ResourceScope scope = ResourceScope.newConfinedScope();){
                MemorySegment streamIdSegment = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                while (quiche_h.quiche_stream_iter_next(quiche_stream_iter, streamIdSegment.address()) != 0) {
                    long streamId = ForeignIncubatorQuicheConnection.getLong(streamIdSegment);
                    result.add(streamId);
                }
            }
            quiche_h.quiche_stream_iter_free(quiche_stream_iter);
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public int feedCipherBytes(ByteBuffer buffer, SocketAddress local, SocketAddress peer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long received;
            if (this.quicheConn == null) {
                throw new IOException("Cannot receive when not connected");
            }
            try (ResourceScope scope = ResourceScope.newConfinedScope();){
                quiche_recv_info.setSocketAddress(this.recvInfo, local, peer, scope);
                if (buffer.isDirect()) {
                    MemorySegment bufferSegment = MemorySegment.ofByteBuffer((ByteBuffer)buffer);
                    received = quiche_h.quiche_conn_recv(this.quicheConn, bufferSegment.address(), buffer.remaining(), this.recvInfo.address());
                } else {
                    MemorySegment bufferSegment = MemorySegment.allocateNative((long)buffer.remaining(), (ResourceScope)scope);
                    int prevPosition = buffer.position();
                    bufferSegment.asByteBuffer().put(buffer);
                    buffer.position(prevPosition);
                    received = quiche_h.quiche_conn_recv(this.quicheConn, bufferSegment.address(), buffer.remaining(), this.recvInfo.address());
                }
            }
            if (received < 0L) {
                throw new IOException("failed to receive packet; quiche_err=" + Quiche.quiche_error.errToString((long)received) + " quic_err=" + Quiche.quic_error.errToString((long)this.getLocalCloseInfo().error()));
            }
            buffer.position((int)((long)buffer.position() + received));
            int n = (int)received;
            return n;
        }
    }

    public int drainCipherBytes(ByteBuffer buffer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long written;
            if (this.quicheConn == null) {
                throw new IOException("Cannot send when not connected");
            }
            int prevPosition = buffer.position();
            if (buffer.isDirect()) {
                MemorySegment bufferSegment = MemorySegment.ofByteBuffer((ByteBuffer)buffer);
                written = quiche_h.quiche_conn_send(this.quicheConn, bufferSegment.address(), buffer.remaining(), this.sendInfo.address());
            } else {
                try (ResourceScope scope = ResourceScope.newConfinedScope();){
                    MemorySegment bufferSegment = MemorySegment.allocateNative((long)buffer.remaining(), (ResourceScope)scope);
                    written = quiche_h.quiche_conn_send(this.quicheConn, bufferSegment.address(), buffer.remaining(), this.sendInfo.address());
                    buffer.put(bufferSegment.asByteBuffer().slice().limit((int)written));
                    buffer.position(prevPosition);
                }
            }
            if (written == -1L) {
                int n = 0;
                return n;
            }
            if (written < 0L) {
                throw new IOException("failed to send packet; quiche_err=" + Quiche.quiche_error.errToString((long)written));
            }
            buffer.position((int)((long)prevPosition + written));
            int n = (int)written;
            return n;
        }
    }

    public boolean isConnectionClosed() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_is_closed(this.quicheConn) != 0;
            return bl;
        }
    }

    public boolean isConnectionEstablished() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_is_established(this.quicheConn) != 0;
            return bl;
        }
    }

    public long nextTimeout() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            long l = quiche_h.quiche_conn_timeout_as_millis(this.quicheConn);
            return l;
        }
    }

    public void onTimeout() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            quiche_h.quiche_conn_on_timeout(this.quicheConn);
        }
    }

    public String getNegotiatedProtocol() {
        try (AutoLock ignore = this.lock.lock();){
            String string;
            block17: {
                long outLen;
                MemorySegment outSegment;
                ResourceScope scope;
                block15: {
                    String string2;
                    block16: {
                        scope = ResourceScope.newConfinedScope();
                        try {
                            if (this.quicheConn == null) {
                                throw new IllegalStateException("connection was released");
                            }
                            outSegment = MemorySegment.allocateNative((MemoryLayout)CLinker.C_POINTER, (ResourceScope)scope);
                            MemorySegment outLenSegment = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                            quiche_h.quiche_conn_application_proto(this.quicheConn, outSegment.address(), outLenSegment.address());
                            outLen = ForeignIncubatorQuicheConnection.getLong(outLenSegment);
                            if (outLen != 0L) break block15;
                            string2 = null;
                            if (scope == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return string2;
                }
                byte[] out = new byte[(int)outLen];
                MemoryAddress memoryAddress = MemoryAddress.ofLong((long)ForeignIncubatorQuicheConnection.getLong(outSegment));
                memoryAddress.asSegment(outLen, ResourceScope.globalScope()).asByteBuffer().get(out);
                string = new String(out, StandardCharsets.UTF_8);
                if (scope == null) break block17;
                scope.close();
            }
            return string;
        }
    }

    public boolean close(long error, String reason) {
        try (AutoLock ignore = this.lock.lock();){
            int rc;
            if (this.quicheConn == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection was released");
                }
                boolean bl = false;
                return bl;
            }
            if (reason == null) {
                rc = quiche_h.quiche_conn_close(this.quicheConn, (byte)1, error, MemoryAddress.NULL, 0L);
            } else {
                try (ResourceScope scope = ResourceScope.newConfinedScope();){
                    byte[] reasonBytes = reason.getBytes(StandardCharsets.UTF_8);
                    MemorySegment reasonSegment = MemorySegment.allocateNative((long)reasonBytes.length, (ResourceScope)scope);
                    reasonSegment.asByteBuffer().put(reasonBytes);
                    int length = reasonBytes.length;
                    MemoryAddress reasonAddress = reasonSegment.address();
                    rc = quiche_h.quiche_conn_close(this.quicheConn, (byte)1, error, reasonAddress, length);
                }
            }
            if (rc == 0) {
                boolean bl = true;
                return bl;
            }
            if ((long)rc == -1L) {
                boolean bl = false;
                return bl;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not close connection: {}", (Object)Quiche.quiche_error.errToString((long)rc));
            }
            boolean bl = false;
            return bl;
        }
    }

    public void dispose() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn != null) {
                quiche_h.quiche_conn_free(this.quicheConn);
            }
            this.quicheConn = null;
            if (this.quicheConfig != null) {
                quiche_h.quiche_config_free(this.quicheConfig);
            }
            this.quicheConfig = null;
            if (this.scope != null) {
                this.scope.close();
            }
            this.scope = null;
            this.sendInfo = null;
            this.recvInfo = null;
            this.stats = null;
            this.pathStats = null;
        }
    }

    public boolean isDraining() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_is_draining(this.quicheConn) != 0;
            return bl;
        }
    }

    public int maxLocalStreams() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            quiche_h.quiche_conn_stats(this.quicheConn, this.stats.address());
            int n = (int)quiche_stats.get_peer_initial_max_streams_bidi(this.stats);
            return n;
        }
    }

    public long windowCapacity() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            quiche_h.quiche_conn_path_stats(this.quicheConn, 0L, this.pathStats.address());
            long l = quiche_path_stats.get_cwnd(this.pathStats);
            return l;
        }
    }

    public long windowCapacity(long streamId) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            long value = quiche_h.quiche_conn_stream_capacity(this.quicheConn, streamId);
            if (value < 0L && LOG.isDebugEnabled()) {
                LOG.debug("could not read window capacity for stream {} quiche_err={}", (Object)streamId, (Object)Quiche.quiche_error.errToString((long)value));
            }
            long l = value;
            return l;
        }
    }

    public void shutdownStream(long streamId, boolean writeSide, long error) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            int direction = writeSide ? 1 : 0;
            int rc = quiche_h.quiche_conn_stream_shutdown(this.quicheConn, streamId, direction, error);
            if (rc == 0 || (long)rc == -1L) {
                return;
            }
            throw new IOException("failed to shutdown stream " + streamId + ": " + Quiche.quiche_error.errToString((long)rc));
        }
    }

    public int feedClearBytesForStream(long streamId, ByteBuffer buffer, boolean last) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long written;
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            if (buffer.isDirect()) {
                MemorySegment bufferSegment = MemorySegment.ofByteBuffer((ByteBuffer)buffer);
                written = quiche_h.quiche_conn_stream_send(this.quicheConn, streamId, bufferSegment.address(), buffer.remaining(), last ? (byte)1 : 0);
            } else {
                try (ResourceScope scope = ResourceScope.newConfinedScope();){
                    if (buffer.remaining() == 0) {
                        written = quiche_h.quiche_conn_stream_send(this.quicheConn, streamId, MemoryAddress.NULL, 0L, last ? (byte)1 : 0);
                    } else {
                        MemorySegment bufferSegment = MemorySegment.allocateNative((long)buffer.remaining(), (ResourceScope)scope);
                        int prevPosition = buffer.position();
                        bufferSegment.asByteBuffer().put(buffer);
                        buffer.position(prevPosition);
                        written = quiche_h.quiche_conn_stream_send(this.quicheConn, streamId, bufferSegment.address(), buffer.remaining(), last ? (byte)1 : 0);
                    }
                }
            }
            if (written == -1L) {
                int rc = quiche_h.quiche_conn_stream_writable(this.quicheConn, streamId, buffer.remaining());
                if (rc < 0) {
                    throw new IOException("failed to write to stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)rc));
                }
                int n = 0;
                return n;
            }
            if (written < 0L) {
                throw new IOException("failed to write to stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)written));
            }
            buffer.position((int)((long)buffer.position() + written));
            int n = (int)written;
            return n;
        }
    }

    public int drainClearBytesForStream(long streamId, ByteBuffer buffer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long read;
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            try (ResourceScope scope = ResourceScope.newConfinedScope();){
                if (buffer.isDirect()) {
                    MemorySegment bufferSegment = MemorySegment.ofByteBuffer((ByteBuffer)buffer);
                    MemorySegment fin = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
                    read = quiche_h.quiche_conn_stream_recv(this.quicheConn, streamId, bufferSegment.address(), buffer.remaining(), fin.address());
                } else {
                    MemorySegment bufferSegment = MemorySegment.allocateNative((long)buffer.remaining(), (ResourceScope)scope);
                    MemorySegment fin = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
                    read = quiche_h.quiche_conn_stream_recv(this.quicheConn, streamId, bufferSegment.address(), buffer.remaining(), fin.address());
                    int prevPosition = buffer.position();
                    buffer.put(bufferSegment.asByteBuffer().limit((int)read));
                    buffer.position(prevPosition);
                }
            }
            if (read == -1L) {
                int n = this.isStreamFinished(streamId) ? -1 : 0;
                return n;
            }
            if (read < 0L) {
                throw new IOException("failed to read from stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)read));
            }
            buffer.position((int)((long)buffer.position() + read));
            int n = (int)read;
            return n;
        }
    }

    public boolean isStreamFinished(long streamId) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_stream_finished(this.quicheConn, streamId) != 0;
            return bl;
        }
    }

    public QuicheConnection.CloseInfo getRemoteCloseInfo() {
        try (AutoLock ignore = this.lock.lock();){
            QuicheConnection.CloseInfo closeInfo;
            block19: {
                ResourceScope scope;
                block17: {
                    QuicheConnection.CloseInfo closeInfo2;
                    block18: {
                        if (this.quicheConn == null) {
                            throw new IllegalStateException("connection was released");
                        }
                        scope = ResourceScope.newConfinedScope();
                        try {
                            String reasonValue;
                            MemorySegment app = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
                            MemorySegment error = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                            MemorySegment reason = MemorySegment.allocateNative((MemoryLayout)CLinker.C_POINTER, (ResourceScope)scope);
                            MemorySegment reasonLength = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                            if (quiche_h.quiche_conn_peer_error(this.quicheConn, app.address(), error.address(), reason.address(), reasonLength.address()) == 0) break block17;
                            long errorValue = ForeignIncubatorQuicheConnection.getLong(error);
                            long reasonLengthValue = ForeignIncubatorQuicheConnection.getLong(reasonLength);
                            if (reasonLengthValue == 0L) {
                                reasonValue = null;
                            } else {
                                byte[] reasonBytes = new byte[(int)reasonLengthValue];
                                MemoryAddress memoryAddress = MemoryAddress.ofLong((long)ForeignIncubatorQuicheConnection.getLong(reason));
                                memoryAddress.asSegment(reasonLengthValue, ResourceScope.globalScope()).asByteBuffer().get(reasonBytes);
                                reasonValue = new String(reasonBytes, StandardCharsets.UTF_8);
                            }
                            closeInfo2 = new QuicheConnection.CloseInfo(errorValue, reasonValue);
                            if (scope == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return closeInfo2;
                }
                closeInfo = null;
                if (scope == null) break block19;
                scope.close();
            }
            return closeInfo;
        }
    }

    public QuicheConnection.CloseInfo getLocalCloseInfo() {
        try (AutoLock ignore = this.lock.lock();){
            QuicheConnection.CloseInfo closeInfo;
            block19: {
                ResourceScope scope;
                block17: {
                    QuicheConnection.CloseInfo closeInfo2;
                    block18: {
                        if (this.quicheConn == null) {
                            throw new IllegalStateException("connection was released");
                        }
                        scope = ResourceScope.newConfinedScope();
                        try {
                            String reasonValue;
                            MemorySegment app = MemorySegment.allocateNative((MemoryLayout)CLinker.C_CHAR, (ResourceScope)scope);
                            MemorySegment error = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                            MemorySegment reason = MemorySegment.allocateNative((MemoryLayout)CLinker.C_POINTER, (ResourceScope)scope);
                            MemorySegment reasonLength = MemorySegment.allocateNative((MemoryLayout)CLinker.C_LONG, (ResourceScope)scope);
                            if (quiche_h.quiche_conn_local_error(this.quicheConn, app.address(), error.address(), reason.address(), reasonLength.address()) == 0) break block17;
                            long errorValue = ForeignIncubatorQuicheConnection.getLong(error);
                            long reasonLengthValue = ForeignIncubatorQuicheConnection.getLong(reasonLength);
                            if (reasonLengthValue == 0L) {
                                reasonValue = null;
                            } else {
                                byte[] reasonBytes = new byte[(int)reasonLengthValue];
                                MemoryAddress memoryAddress = MemoryAddress.ofLong((long)ForeignIncubatorQuicheConnection.getLong(reason));
                                memoryAddress.asSegment(reasonLengthValue, ResourceScope.globalScope()).asByteBuffer().get(reasonBytes);
                                reasonValue = new String(reasonBytes, StandardCharsets.UTF_8);
                            }
                            closeInfo2 = new QuicheConnection.CloseInfo(errorValue, reasonValue);
                            if (scope == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return closeInfo2;
                }
                closeInfo = null;
                if (scope == null) break block19;
                scope.close();
            }
            return closeInfo;
        }
    }

    private static void putLong(MemorySegment memorySegment, long value) {
        memorySegment.asByteBuffer().order(ByteOrder.nativeOrder()).putLong(value);
    }

    private static long getLong(MemorySegment memorySegment) {
        return memorySegment.asByteBuffer().order(ByteOrder.nativeOrder()).getLong();
    }

    private static int getInt(MemorySegment memorySegment) {
        return memorySegment.asByteBuffer().order(ByteOrder.nativeOrder()).getInt();
    }

    private static byte getByte(MemorySegment memorySegment) {
        return memorySegment.asByteBuffer().get();
    }
}

