/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.util.Arrays;
import org.eclipse.jetty.demos.DumpServlet;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.rewrite.RewriteCustomizer;
import org.eclipse.jetty.rewrite.handler.CompactPathRule;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class RewriteServer {
    public static Server createServer(int port) {
        Server server = new Server(port);
        RewriteCustomizer rewrite = new RewriteCustomizer();
        rewrite.addRule((Rule)new CompactPathRule());
        rewrite.addRule((Rule)new RewriteRegexRule("(.*)foo(.*)", "$1FOO$2"));
        Arrays.stream(server.getConnectors()).forEach(connector -> ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)rewrite));
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(DumpServlet.class, "/*");
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = RewriteServer.createServer(port);
        server.start();
        server.join();
    }
}

