/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.internal.util.TextUtils;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxWebSocketBasicRemote
extends JavaxWebSocketRemoteEndpoint
implements RemoteEndpoint.Basic {
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketBasicRemote.class);

    protected JavaxWebSocketBasicRemote(JavaxWebSocketSession session, CoreSession coreSession) {
        super(session, coreSession);
    }

    public OutputStream getSendStream() throws IOException {
        return this.newMessageOutputStream();
    }

    public Writer getSendWriter() throws IOException {
        return this.newMessageWriter();
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", (Object)BufferUtil.toDetailString((ByteBuffer)data));
        }
        FutureCallback b = new FutureCallback();
        this.sendFrame(new Frame(2).setPayload(data), (Callback)b, false);
        b.block(this.getBlockingTimeout(), TimeUnit.MILLISECONDS);
    }

    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        Frame frame;
        this.assertMessageNotNull(partialByte);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", (Object)BufferUtil.toDetailString((ByteBuffer)partialByte), (Object)isLast);
        }
        switch (this.messageType) {
            case -1: {
                frame = new Frame(2);
                break;
            }
            case 1: {
                throw new IllegalStateException("Cannot send a partial BINARY message: TEXT message in progress");
            }
            case 2: {
                frame = new Frame(0);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot send a partial BINARY message: unrecognized active message type " + OpCode.name((byte)this.messageType));
            }
        }
        frame.setPayload(partialByte);
        frame.setFin(isLast);
        FutureCallback b = new FutureCallback();
        this.sendFrame(frame, (Callback)b, false);
        b.block(this.getBlockingTimeout(), TimeUnit.MILLISECONDS);
    }

    public void sendObject(Object data) throws IOException, EncodeException {
        FutureCallback b = new FutureCallback();
        super.sendObject(data, (Callback)b);
        b.block(this.getBlockingTimeout(), TimeUnit.MILLISECONDS);
    }

    public void sendText(String text) throws IOException {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", (Object)TextUtils.hint((String)text));
        }
        FutureCallback b = new FutureCallback();
        this.sendFrame(new Frame(1).setPayload(text), (Callback)b, false);
        b.block(this.getBlockingTimeout(), TimeUnit.MILLISECONDS);
    }

    public void sendText(String partialMessage, boolean isLast) throws IOException {
        Frame frame;
        this.assertMessageNotNull(partialMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", (Object)TextUtils.hint((String)partialMessage), (Object)isLast);
        }
        switch (this.messageType) {
            case -1: {
                frame = new Frame(1);
                break;
            }
            case 1: {
                frame = new Frame(0);
                break;
            }
            case 2: {
                throw new IllegalStateException("Cannot send a partial TEXT message: BINARY message in progress");
            }
            default: {
                throw new IllegalStateException("Cannot send a partial TEXT message: unrecognized active message type " + OpCode.name((byte)this.messageType));
            }
        }
        frame.setPayload(BufferUtil.toBuffer((String)partialMessage, (Charset)StandardCharsets.UTF_8));
        frame.setFin(isLast);
        FutureCallback b = new FutureCallback();
        this.sendFrame(frame, (Callback)b, false);
        b.block(this.getBlockingTimeout(), TimeUnit.MILLISECONDS);
    }

    private long getBlockingTimeout() {
        long idleTimeout = this.getIdleTimeout();
        return idleTimeout > 0L ? idleTimeout + 1000L : idleTimeout;
    }
}

