/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.fileinits.MavenMetadata;
import org.xml.sax.SAXException;

public class MavenLocalRepoFileInitializer
extends FileInitializer {
    private final Path localRepositoryDir;
    private static final String DEFAULT_REMOTE_REPO = "https://repo1.maven.org/maven2/";
    private final boolean readonly;
    private String mavenRepoUri;

    public MavenLocalRepoFileInitializer(BaseHome baseHome) {
        this(baseHome, null, true);
    }

    public MavenLocalRepoFileInitializer(BaseHome baseHome, Path localRepoDir, boolean readonly) {
        this(baseHome, localRepoDir, readonly, null);
    }

    public MavenLocalRepoFileInitializer(BaseHome baseHome, Path localRepoDir, boolean readonly, String mavenRepoUri) {
        super(baseHome, "maven");
        this.localRepositoryDir = localRepoDir != null ? localRepoDir : MavenLocalRepoFileInitializer.newTempRepo();
        this.readonly = readonly;
        this.mavenRepoUri = mavenRepoUri;
    }

    private static Path newTempRepo() {
        Path javaTempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        return javaTempDir.resolve("jetty-start-downloads");
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        Coordinates coords = this.getCoordinates(uri);
        if (coords == null) {
            return false;
        }
        URI destURI = URI.create(location);
        if (destURI.isAbsolute() && destURI.getScheme().equals("extract")) {
            Path destination;
            String extractLocation;
            Path localFile = this.localRepositoryDir.resolve(coords.toPath());
            if (!FS.canReadFile(localFile)) {
                if (FS.ensureDirectoryExists(localFile.getParent())) {
                    StartLog.info("mkdir " + this._basehome.toShortForm(localFile.getParent()), new Object[0]);
                }
                this.download(coords, localFile);
                if (!FS.canReadFile(localFile)) {
                    throw new IOException("Unable to establish temp copy of file to extract: " + localFile);
                }
            }
            if ((extractLocation = destURI.getSchemeSpecificPart()).equals("/")) {
                destination = this._basehome.getBasePath();
            } else {
                if (!(extractLocation = extractLocation.replaceFirst("^[/\\\\]*", "")).endsWith("/")) {
                    throw new IOException("Extract mode can only unpack to a directory, end your URL with a slash: " + location);
                }
                destination = this._basehome.getBasePath().resolve(extractLocation);
                if (Files.exists(destination, new LinkOption[0]) && !Files.isDirectory(destination, new LinkOption[0])) {
                    throw new IOException("Destination already exists, and is not a directory: " + destination);
                }
                if (!destination.startsWith(this._basehome.getBasePath())) {
                    throw new IOException("For security reasons, Jetty start is unable to extract outside of the ${jetty.base} - " + location);
                }
            }
            FS.extract(localFile, destination);
        } else {
            Path destination = this.getDestination(uri, location);
            if (this.isFilePresent(destination)) {
                return false;
            }
            Path localRepoFile = this.getLocalRepoFile(coords);
            if (localRepoFile != null) {
                if (FS.ensureDirectoryExists(destination.getParent())) {
                    StartLog.info("mkdir " + this._basehome.toShortForm(destination.getParent()), new Object[0]);
                }
                StartLog.info("copy %s to %s", localRepoFile, this._basehome.toShortForm(destination));
                Files.copy(localRepoFile, destination, new CopyOption[0]);
                return true;
            }
            this.download(coords, destination);
        }
        return true;
    }

    private Path getLocalRepoFile(Coordinates coords) throws IOException {
        Path localFile = this.localRepositoryDir.resolve(coords.toPath());
        if (FS.canReadFile(localFile)) {
            return localFile;
        }
        if (!this.readonly) {
            this.download(coords, localFile);
            return localFile;
        }
        return null;
    }

    public String getRemoteUri() {
        if (this.mavenRepoUri != null) {
            return this.mavenRepoUri;
        }
        return System.getProperty("maven.repo.uri", DEFAULT_REMOTE_REPO);
    }

    public Coordinates getCoordinates(URI uri) {
        if (!"maven".equalsIgnoreCase(uri.getScheme())) {
            return null;
        }
        String ssp = uri.getSchemeSpecificPart();
        if (ssp.startsWith("//")) {
            ssp = ssp.substring(2);
        }
        String[] parts = ssp.split("/");
        if (StartLog.isDebugEnabled()) {
            StartLog.debug("ssp = %s", ssp);
            StartLog.debug("parts = %d", parts.length);
            for (int i = 0; i < parts.length; ++i) {
                StartLog.debug("  part[%2d]: [%s]", i, parts[i]);
            }
        }
        if (parts.length < 3) {
            throw new RuntimeException("Not a valid maven:// uri - " + uri);
        }
        Coordinates coords = new Coordinates();
        coords.groupId = parts[0];
        coords.artifactId = parts[1];
        coords.version = parts[2];
        coords.type = "jar";
        coords.classifier = null;
        coords.mavenRepoUri = this.getRemoteUri();
        if (parts.length >= 4) {
            if (Utils.isNotBlank(parts[3])) {
                coords.type = parts[3];
            }
            if (parts.length == 5 && Utils.isNotBlank(parts[4])) {
                coords.classifier = parts[4];
            }
        }
        return coords;
    }

    protected void download(Coordinates coords, Path destination) throws IOException {
        if (coords.version.endsWith("-SNAPSHOT")) {
            Path localRepoMetadataPath = this.localRepositoryDir.resolve(coords.toMetadataPath());
            if (this.isMetadataStale(localRepoMetadataPath)) {
                URI mavenMetadataURI = coords.toSnapshotMetadataXmlURI();
                super.download(mavenMetadataURI, localRepoMetadataPath);
            }
            if (Files.exists(localRepoMetadataPath, new LinkOption[0])) {
                String actualVersion = this.getMetadataVersion(localRepoMetadataPath, coords);
                super.download(coords.toCentralURI(actualVersion), destination);
            }
        } else {
            super.download(coords.toCentralURI(), destination);
        }
    }

    private boolean isMetadataStale(Path localRepoMetadataPath) {
        if (!Files.exists(localRepoMetadataPath, new LinkOption[0])) {
            return true;
        }
        try {
            MavenMetadata mavenMetadata = new MavenMetadata(localRepoMetadataPath);
            return MavenMetadata.isExpiredTimestamp(mavenMetadata.getLastUpdated());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return true;
        }
    }

    private String getMetadataVersion(Path localRepoMetadataPath, Coordinates coords) throws IOException {
        try {
            MavenMetadata mavenMetadata = new MavenMetadata(localRepoMetadataPath);
            MavenMetadata.Snapshot snapshot = mavenMetadata.getSnapshot(coords.classifier, coords.type);
            return snapshot.value;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException("Unable to parse " + localRepoMetadataPath, e);
        }
    }

    @Override
    protected void download(URI uri, Path destination) throws IOException {
        super.download(uri, destination);
    }

    public static class Coordinates {
        public String groupId;
        public String artifactId;
        public String version;
        public String type;
        public String classifier;
        private String mavenRepoUri = "https://repo1.maven.org/maven2/";

        public String toPath() {
            return this.toActualPath(this.version);
        }

        private String toActualPath(String actualVersion) {
            StringBuilder pathlike = new StringBuilder();
            pathlike.append(this.groupId.replace('.', '/'));
            pathlike.append('/').append(this.artifactId);
            pathlike.append('/').append(this.version);
            pathlike.append('/').append(this.artifactId);
            pathlike.append('-').append(actualVersion);
            if (this.classifier != null) {
                pathlike.append('-').append(this.classifier);
            }
            pathlike.append('.').append(this.type);
            return pathlike.toString();
        }

        public String toMetadataPath() {
            StringBuilder pathLike = new StringBuilder();
            pathLike.append(this.groupId.replace('.', '/'));
            pathLike.append('/').append(this.artifactId);
            pathLike.append('/').append(this.version);
            pathLike.append("/maven-metadata.xml");
            return pathLike.toString();
        }

        public URI toCentralURI() {
            return URI.create(this.mavenRepoUri + this.toPath());
        }

        public URI toCentralURI(String actualVersion) {
            return URI.create(this.mavenRepoUri + this.toActualPath(actualVersion));
        }

        public URI toSnapshotMetadataXmlURI() {
            return URI.create(this.mavenRepoUri + this.toMetadataPath());
        }
    }
}

