/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;

public final class KeepInstallerUtil {
    public static final String KEEP_INSTALLER_DESCRIPTION = "Copy the installer to a permanent location on your disk in order to remember your settings and support self updates";
    private static final OomphPlugin.Preference PREF_KEPT = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("kept");
    private static String powerShell;

    private KeepInstallerUtil() {
    }

    public static void createShortCut(String specialFolder, String target) {
        KeepInstallerUtil.createShortCut(specialFolder, null, target, PropertiesUtil.getProductName());
    }

    public static void createShortCut(String specialFolder, String groupName, String target, String shortcutName) {
        try {
            String powerShell = KeepInstallerUtil.getPowerShell();
            if (powerShell != null) {
                if (groupName != null) {
                    Runtime.getRuntime().exec(new String[]{powerShell, "-command", "& { $folderPath = Join-Path ([Environment]::GetFolderPath('" + specialFolder + "')) '" + groupName + "';" + "[system.io.directory]::CreateDirectory($folderPath); " + "$linkPath = Join-Path $folderPath '" + shortcutName + ".lnk'; $targetPath = '" + target + "'; $link = (New-Object -ComObject WScript.Shell).CreateShortcut( $linkpath ); $link.TargetPath = $targetPath; $link.Save()}"});
                } else {
                    Runtime.getRuntime().exec(new String[]{powerShell, "-command", "& {$linkPath = Join-Path ([Environment]::GetFolderPath('" + specialFolder + "')) '" + shortcutName + ".lnk'; $targetPath = '" + target + "'; $link = (New-Object -ComObject WScript.Shell).CreateShortcut( $linkpath ); $link.TargetPath = $targetPath; $link.Save()}"});
                }
            }
        }
        catch (IOException ex) {
            SetupInstallerPlugin.INSTANCE.log(ex);
        }
    }

    public static void pinToTaskBar(String location, String launcherName) {
        try {
            String powerShell = KeepInstallerUtil.getPowerShell();
            if (powerShell != null) {
                Runtime.getRuntime().exec(new String[]{powerShell, "-command", "& { (new-object -c shell.application).namespace('" + location + "').parsename('" + launcherName + "').invokeverb('taskbarpin') }"});
            }
        }
        catch (IOException ex) {
            SetupInstallerPlugin.INSTANCE.log(ex);
        }
    }

    protected void keepInstaller(String launcher, boolean startMenu, boolean desktop, boolean quickLaunch) {
    }

    public static boolean canKeepInstaller() {
        if (!KeepInstallerUtil.isInstallerKept() && OS.INSTANCE.isWin()) {
            String launcher = OS.getCurrentLauncher((boolean)false);
            return launcher != null && launcher.startsWith(PropertiesUtil.getTmpDir());
        }
        return false;
    }

    public static String getPowerShell() {
        block6: {
            if (powerShell == null) {
                try {
                    File[] versions;
                    File powerShellFolder;
                    File system32;
                    String systemRoot = System.getenv("SystemRoot");
                    if (systemRoot == null || !(system32 = new File(systemRoot, "system32")).isDirectory() || !(powerShellFolder = new File(system32, "WindowsPowerShell")).isDirectory() || (versions = powerShellFolder.listFiles()) == null) break block6;
                    File[] fileArray = versions;
                    int n = versions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block7: {
                            File version = fileArray[n2];
                            try {
                                File executable = new File(version, "powershell.exe");
                                if (!executable.isFile()) break block7;
                                powerShell = executable.getAbsolutePath();
                                break;
                            }
                            catch (Exception exception) {}
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return powerShell;
    }

    public static void keepInstaller(String targetLocation, boolean startPermanentInstaller, String launcher, boolean startMenu, boolean desktop, boolean quickLaunch) {
        File source = new File(launcher).getParentFile();
        File target = new File(targetLocation);
        IOUtil.copyTree((File)source, (File)target, (boolean)true);
        String launcherName = new File(launcher).getName();
        String permanentLauncher = new File(target, launcherName).getAbsolutePath();
        if (startPermanentInstaller) {
            try {
                Runtime.getRuntime().exec(permanentLauncher);
            }
            catch (Exception ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        } else {
            String url = target.toURI().toString();
            OS.INSTANCE.openSystemBrowser(url);
        }
        if (startMenu) {
            KeepInstallerUtil.createShortCut("Programs", permanentLauncher);
        }
        if (desktop) {
            KeepInstallerUtil.createShortCut("Desktop", permanentLauncher);
        }
        if (quickLaunch) {
            KeepInstallerUtil.pinToTaskBar(targetLocation, launcherName);
        }
        KeepInstallerUtil.setKeepInstaller(true);
    }

    public static boolean isInstallerKept() {
        return PREF_KEPT.get(false);
    }

    public static void setKeepInstaller(boolean keep) {
        PREF_KEPT.set(keep);
    }
}

