/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.celleditor;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class BasicTableEditor
extends TableEditor {
    protected Table table;

    public BasicTableEditor(Table table) {
        super(table);
        this.table = table;
        this.horizontalAlignment = 16384;
        this.grabHorizontal = true;
        this.minimumWidth = 50;
    }

    protected TableItem getSelection() {
        TableItem[] selection = this.table.getSelection();
        return selection.length == 1 ? selection[0] : null;
    }

    protected void edit(TableItem item, int column) {
        if (this.canEdit(item, column)) {
            this.setEditor(this.createEditor(item, column), item, column);
        }
    }

    protected boolean canEdit(TableItem item, int column) {
        return true;
    }

    protected abstract Control createEditor(TableItem var1, int var2);

    protected Text createTextEditor(final TableItem item, final int column) {
        final Text text = new Text((Composite)this.table, 0);
        text.setText(item.getText(column));
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BasicTableEditor.this.endEditing(item, column, (Control)text, true);
            }
        });
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                    BasicTableEditor.this.endEditing(item, column, (Control)text, false);
                } else if (e.detail == 4) {
                    e.doit = false;
                    BasicTableEditor.this.endEditing(item, column, (Control)text, true);
                }
            }
        });
        text.selectAll();
        text.setFocus();
        return text;
    }

    protected void endEditing(TableItem item, int column, Control editor, boolean accept) {
        if (this.getEditor() != null) {
            if (accept) {
                this.update(item, column, editor);
            }
            this.setEditor(null);
            editor.dispose();
        }
    }

    protected abstract void update(TableItem var1, int var2, Control var3);
}

