/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public final class NavigatorActivationService
implements INavigatorActivationService {
    private static final String ACTIVATED_EXTENSIONS = ".activatedExtensions";
    private static final NavigatorContentDescriptorManager CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorManager.getInstance();
    private static final INavigatorContentDescriptor[] NO_DESCRIPTORS = new INavigatorContentDescriptor[0];
    private static final String DELIM = ";";
    private static final char EQUALS = '=';
    private final Map<String, Boolean> activatedExtensionsMap = new HashMap<String, Boolean>();
    private final ListenerList<IExtensionActivationListener> listeners = new ListenerList();
    private INavigatorContentService contentService;

    public NavigatorActivationService(INavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.revertExtensionActivations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNavigatorExtensionActive(String aNavigatorExtensionId) {
        Boolean b = this.activatedExtensionsMap.get(aNavigatorExtensionId);
        if (b != null) {
            return b;
        }
        Map<String, Boolean> map = this.activatedExtensionsMap;
        synchronized (map) {
            NavigatorContentDescriptor descriptor;
            block7: {
                descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(aNavigatorExtensionId);
                if (descriptor != null) break block7;
                return false;
            }
            if (descriptor.isActiveByDefault()) {
                this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.TRUE);
            } else {
                this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.FALSE);
            }
            return descriptor.isActiveByDefault();
        }
    }

    public void setActive(String aNavigatorExtensionId, boolean toEnable) {
        boolean currentlyActive = this.isNavigatorExtensionActive(aNavigatorExtensionId);
        if (currentlyActive == toEnable) {
            return;
        }
        if (toEnable) {
            this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.TRUE);
        } else {
            this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.FALSE);
        }
        this.notifyListeners(new String[]{aNavigatorExtensionId}, toEnable);
    }

    public void setActive(String[] aNavigatorExtensionIds, boolean toEnable) {
        if (toEnable) {
            String[] stringArray = aNavigatorExtensionIds;
            int n = aNavigatorExtensionIds.length;
            int n2 = 0;
            while (n2 < n) {
                String aNavigatorExtensionId = stringArray[n2];
                this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.TRUE);
                ++n2;
            }
        } else {
            String[] stringArray = aNavigatorExtensionIds;
            int n = aNavigatorExtensionIds.length;
            int n3 = 0;
            while (n3 < n) {
                String aNavigatorExtensionId = stringArray[n3];
                this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.FALSE);
                ++n3;
            }
        }
        this.notifyListeners(aNavigatorExtensionIds, toEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistExtensionActivations() {
        IEclipsePreferences prefs = NavigatorContentService.getPreferencesRoot();
        Map<String, Boolean> map = this.activatedExtensionsMap;
        synchronized (map) {
            Iterator<String> activatedExtensionsIterator = this.activatedExtensionsMap.keySet().iterator();
            StringBuilder preferenceValue = new StringBuilder();
            String navigatorExtensionId = null;
            boolean isActive = false;
            while (activatedExtensionsIterator.hasNext()) {
                navigatorExtensionId = activatedExtensionsIterator.next();
                isActive = this.isNavigatorExtensionActive(navigatorExtensionId);
                preferenceValue.append(navigatorExtensionId).append('=').append(isActive ? Boolean.TRUE : Boolean.FALSE).append(DELIM);
            }
            prefs.put(this.getPreferenceKey(), preferenceValue.toString());
        }
        NavigatorContentService.flushPreferences(prefs);
    }

    @Override
    public void addExtensionActivationListener(IExtensionActivationListener aListener) {
        this.listeners.add((Object)aListener);
    }

    @Override
    public void removeExtensionActivationListener(IExtensionActivationListener aListener) {
        this.listeners.remove((Object)aListener);
    }

    private void notifyListeners(String[] navigatorExtensionIds, boolean toEnable) {
        if (navigatorExtensionIds != null) {
            if (navigatorExtensionIds.length > 1) {
                Arrays.sort(navigatorExtensionIds);
            }
            for (IExtensionActivationListener element : this.listeners) {
                element.onExtensionActivation(this.contentService.getViewerId(), navigatorExtensionIds, toEnable);
            }
        }
    }

    private void revertExtensionActivations() {
        IEclipsePreferences prefs = NavigatorContentService.getPreferencesRoot();
        String activatedExtensionsString = prefs.get(this.getPreferenceKey(), null);
        if (activatedExtensionsString != null && activatedExtensionsString.length() > 0) {
            String[] contentExtensionIds = activatedExtensionsString.split(DELIM);
            String id = null;
            String booleanString = null;
            int indx = 0;
            String[] stringArray = contentExtensionIds;
            int n = contentExtensionIds.length;
            int n2 = 0;
            while (n2 < n) {
                String contentExtensionId = stringArray[n2];
                indx = contentExtensionId.indexOf(61);
                if (indx > -1) {
                    id = contentExtensionId.substring(0, indx);
                    booleanString = contentExtensionId.substring(indx + 1, contentExtensionId.length());
                    this.activatedExtensionsMap.put(id, Boolean.valueOf(booleanString));
                } else {
                    NavigatorContentDescriptor descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(contentExtensionId);
                    if (descriptor != null) {
                        this.activatedExtensionsMap.put(id, descriptor.isActiveByDefault());
                    }
                }
                ++n2;
            }
        } else {
            NavigatorContentDescriptor[] contentDescriptors;
            NavigatorContentDescriptor[] navigatorContentDescriptorArray = contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            int n = contentDescriptors.length;
            int n3 = 0;
            while (n3 < n) {
                NavigatorContentDescriptor contentDescriptor = navigatorContentDescriptorArray[n3];
                if (contentDescriptor.isActiveByDefault()) {
                    this.activatedExtensionsMap.put(contentDescriptor.getId(), Boolean.TRUE);
                }
                ++n3;
            }
        }
    }

    private String getPreferenceKey() {
        return this.contentService.getViewerId() + ACTIVATED_EXTENSIONS;
    }

    @Override
    public INavigatorContentDescriptor[] activateExtensions(String[] extensionIds, boolean toDeactivateAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        this.setActive(extensionIds, true);
        String[] stringArray = extensionIds;
        int n = extensionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionId = stringArray[n2];
            activatedDescriptors.add(CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(extensionId));
            ++n2;
        }
        if (toDeactivateAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            NavigatorContentDescriptor[] navigatorContentDescriptorArray = descriptors;
            int n3 = descriptors.length;
            int n4 = 0;
            while (n4 < n3) {
                NavigatorContentDescriptor descriptor = navigatorContentDescriptorArray[n4];
                String[] stringArray2 = extensionIds;
                int n5 = extensionIds.length;
                int n6 = 0;
                while (n6 < n5) {
                    String extensionId = stringArray2[n6];
                    if (descriptor.getId().equals(extensionId)) {
                        descriptorList.remove(descriptor);
                    }
                    ++n6;
                }
                ++n4;
            }
            String[] deactivatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorList.get(i);
                deactivatedExtensions[i] = descriptor.getId();
                ++i;
            }
            this.setActive(deactivatedExtensions, false);
        }
        if (activatedDescriptors.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }

    @Override
    public INavigatorContentDescriptor[] deactivateExtensions(String[] extensionIds, boolean toEnableAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        this.setActive(extensionIds, false);
        if (toEnableAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            NavigatorContentDescriptor[] navigatorContentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                NavigatorContentDescriptor descriptor = navigatorContentDescriptorArray[n2];
                String[] stringArray = extensionIds;
                int n3 = extensionIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String extensionId = stringArray[n4];
                    if (descriptor.getId().equals(extensionId)) {
                        descriptorList.remove(descriptor);
                    }
                    ++n4;
                }
                ++n2;
            }
            String[] activatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)descriptorList.get(i);
                activatedExtensions[i] = descriptor.getId();
                activatedDescriptors.add(descriptor);
                ++i;
            }
            this.setActive(activatedExtensions, true);
        }
        if (activatedDescriptors.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }
}

