/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.security.storage.friends.IStorageTask;
import org.eclipse.equinox.internal.security.storage.friends.IUICallbacks;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.ChallengeResponseDialog;
import org.eclipse.equinox.internal.security.ui.storage.StorageUtils;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class UICallbackProvider
implements IUICallbacks {
    public void setupPasswordRecovery(final int size, final String moduleID, final IPreferencesContainer container) {
        if (!StorageUtils.showUI(container)) {
            return;
        }
        UIJob reciverySetupJob = new UIJob(SecUIMessages.pswJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean reply = MessageDialog.openQuestion((Shell)StorageUtils.getShell(), (String)SecUIMessages.pswdRecoveryOptionTitle, (String)SecUIMessages.pswdRecoveryOptionMsg);
                if (!reply) {
                    return Status.OK_STATUS;
                }
                ChallengeResponseDialog dialog = new ChallengeResponseDialog(size, StorageUtils.getShell());
                dialog.open();
                String[][] result = dialog.getResult();
                if (result != null) {
                    InternalExchangeUtils.setupRecovery((String[][])result, (String)moduleID, (IPreferencesContainer)container);
                }
                return Status.OK_STATUS;
            }
        };
        reciverySetupJob.setUser(false);
        reciverySetupJob.schedule();
    }

    public void execute(final IStorageTask callback) throws StorageException {
        if (!StorageUtils.showUI(null)) {
            callback.execute();
            return;
        }
        final StorageException[] exception = new StorageException[]{null};
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed() && display.getThread() == Thread.currentThread()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                InitWithProgress task = new InitWithProgress(callback);
                try {
                    progressService.busyCursorWhile((IRunnableWithProgress)task);
                }
                catch (InvocationTargetException e1) {
                    storageExceptionArray[0] = new StorageException(0, (Throwable)e1);
                    return;
                }
                catch (InterruptedException e2) {
                    storageExceptionArray[0] = new StorageException(0, SecUIMessages.initCancelled);
                    return;
                }
                storageExceptionArray[0] = task.getException();
            });
        } else {
            Job job = new Job(SecUIMessages.secureStorageInitialization){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        callback.execute();
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                exception[0] = new StorageException(0, SecUIMessages.initCancelled);
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public Boolean ask(String msg) {
        if (!StorageUtils.showUI(null)) {
            return null;
        }
        return (Boolean)PlatformUI.getWorkbench().getDisplay().syncCall(() -> MessageDialog.openConfirm((Shell)StorageUtils.getShell(), (String)SecUIMessages.generalDialogTitle, (String)msg));
    }

    public boolean runningUI() {
        return StorageUtils.runningUI();
    }

    private static class InitWithProgress
    implements IRunnableWithProgress {
        private IStorageTask callback;
        private StorageException exception = null;

        public InitWithProgress(IStorageTask callback) {
            this.callback = callback;
        }

        public StorageException getException() {
            return this.exception;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(SecUIMessages.initializing, -1);
            try {
                this.callback.execute();
            }
            catch (StorageException e) {
                this.exception = e;
            }
            monitor.done();
        }
    }
}

